/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.math.MathUtils;
import dr.math.distributions.RandomGenerator;

public class ExponentialTiltedStableDistribution
implements RandomGenerator {
    private static final double doubleRejectionCost = 4.0;
    private static final double M_PI = Math.PI;
    private static final double M_SQRT_PI = Math.sqrt(Math.PI);
    private static final double M_SQRT2 = Math.sqrt(2.0);
    private static final double M_PI_2 = 1.5707963267948966;

    @Override
    public Object nextRandom() {
        return null;
    }

    @Override
    public double logPdf(Object object) {
        return 0.0;
    }

    public static double nextTiltedStable(double d, double d2) {
        double d3 = Math.pow(d2, d);
        if (d3 < 4.0) {
            return ExponentialTiltedStableDistribution.divideAndConquerSample(d, d2);
        }
        return ExponentialTiltedStableDistribution.doubleRejectionSample(d, d2);
    }

    private static double divideAndConquerSample(double d, double d2) {
        int n = Math.max(1, (int)Math.floor(Math.pow(d2, d)));
        double d3 = Math.pow(1.0 / (double)n, 1.0 / d);
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            d4 += ExponentialTiltedStableDistribution.dividedRvSample(d, d2, d3);
        }
        return d4;
    }

    private static double dividedRvSample(double d, double d2, double d3) {
        boolean bl = false;
        double d4 = 0.0;
        while (!bl) {
            d4 = d3 * ExponentialTiltedStableDistribution.sampleNonTiltedRv(d);
            bl = MathUtils.nextDouble() < Math.exp(-d2 * d4);
        }
        return d4;
    }

    private static double sampleNonTiltedRv(double d) {
        double d2 = MathUtils.nextDouble();
        double d3 = -Math.log(MathUtils.nextDouble());
        return Math.pow(ExponentialTiltedStableDistribution.zolotarevFunction(Math.PI * d2, d) / d3, (1.0 - d) / d);
    }

    private static double doubleRejectionSample(double d, double d2) {
        return ExponentialTiltedStableDistribution.retstable_LD(d2, d);
    }

    private static double zolotarevFunction(double d, double d2) {
        return Math.pow(Math.pow((1.0 - d2) * ExponentialTiltedStableDistribution.sinc((1.0 - d2) * d), 1.0 - d2) * Math.pow(d2 * ExponentialTiltedStableDistribution.sinc(d2 * d), d2) / ExponentialTiltedStableDistribution.sinc(d), 1.0 / (1.0 - d2));
    }

    private static double retstable_LD(double d, double d2) {
        double d3;
        if (d2 == 1.0) {
            return 1.0;
        }
        double d4 = Math.sqrt(1.5707963267948966);
        double d5 = 2.0 + d4;
        double d6 = 1.0 - d2;
        double d7 = d6 / d2;
        double d8 = Math.pow(d, d2);
        double d9 = d8 * d2 * d6;
        double d10 = Math.sqrt(d9);
        double d11 = d5 * d10;
        double d12 = (1.0 + M_SQRT2 * d11) / Math.PI;
        double d13 = d11 * Math.exp(-d9 * Math.PI * Math.PI / 8.0) / M_SQRT_PI;
        double d14 = d4 * d12 / d10;
        double d15 = 2.0 * M_SQRT_PI * d13;
        double d16 = d12 * Math.PI;
        while (true) {
            double d17;
            double d18;
            double d19 = MathUtils.nextDouble();
            if (d9 >= 1.0) {
                if (d19 < d14 / (d14 + d15)) {
                    d18 = Math.abs(MathUtils.nextGaussian()) / d10;
                } else {
                    d17 = MathUtils.nextDouble();
                    d18 = Math.PI * (1.0 - d17 * d17);
                }
            } else {
                d17 = MathUtils.nextDouble();
                d18 = d19 < d16 / (d15 + d16) ? Math.PI * d17 : Math.PI * (1.0 - d17 * d17);
            }
            d17 = MathUtils.nextDouble();
            double d20 = Math.sqrt(ExponentialTiltedStableDistribution.BdB0(d18, d2));
            double d21 = 1.0 / (1.0 - Math.pow(1.0 + d2 * d20 / d10, -1.0 / d2));
            double d22 = Math.PI * Math.exp(-d8 * (1.0 - 1.0 / (d20 * d20))) / ((1.0 + d4) * d10 / d20 + d21);
            double d23 = 0.0;
            if (d18 >= 0.0 && d9 >= 1.0) {
                d23 += d12 * Math.exp(-d9 * d18 * d18 / 2.0);
            }
            if (d18 > 0.0 && d18 < Math.PI) {
                d23 += d13 / Math.sqrt(Math.PI - d18);
            }
            if (d18 >= 0.0 && d18 <= Math.PI && d9 < 1.0) {
                d23 += d12;
            }
            double d24 = d17 * (d22 *= d23);
            if (!(d18 < Math.PI) || !(d24 <= 1.0)) continue;
            d19 = ExponentialTiltedStableDistribution.zolotarevFunction(d18, d2);
            d17 = Math.pow(d7 / d19, d2) * d8;
            d20 = Math.sqrt(d17 * d2 / d19);
            d22 = d20 * d4;
            d23 = d21 / d19;
            double d25 = d22 + d20 + d23;
            double d26 = MathUtils.nextDouble();
            double d27 = 0.0;
            double d28 = 0.0;
            if (d26 < d22 / d25) {
                d27 = MathUtils.nextGaussian();
                d3 = d17 - d20 * Math.abs(d27);
            } else if (d26 < (d22 + d20) / d25) {
                d3 = d17 + d20 * MathUtils.nextDouble();
            } else {
                d28 = -Math.log(MathUtils.nextDouble());
                d3 = d17 + d20 + d28 * d23;
            }
            double d29 = -Math.log(d24);
            double d30 = d19 * (d3 - d17) + Math.exp(1.0 / d2 * Math.log(d8) - d7 * Math.log(d17)) * (Math.pow(d17 / d3, d7) - 1.0);
            if (d3 < d17) {
                d30 -= d27 * d27 / 2.0;
            } else if (d3 > d17 + d20) {
                d30 -= d28;
            }
            if (d3 >= 0.0 && d30 <= d29) break;
        }
        return Math.exp(-d7 * Math.log(d3));
    }

    private static double BdB0(double d, double d2) {
        double d3 = 1.0 - d2;
        double d4 = Math.pow(ExponentialTiltedStableDistribution.sinc(d2 * d), d2) * Math.pow(ExponentialTiltedStableDistribution.sinc(d3 * d), d3);
        return ExponentialTiltedStableDistribution.sinc(d) / d4;
    }

    private static double sinc(double d) {
        double d2 = Math.abs(d);
        if (d2 < 0.006) {
            if (d == 0.0) {
                return 1.0;
            }
            double d3 = d * d;
            if (d2 < 2.0E-4) {
                return 1.0 - d3 / 6.0;
            }
            return 1.0 - d3 / 6.0 * (1.0 - d3 / 20.0);
        }
        return Math.sin(d) / d;
    }
}

