/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack.structure;

import org.chocosolver.solver.constraints.nary.knapsack.structure.InnerNode;
import org.chocosolver.solver.constraints.nary.knapsack.structure.KPItem;

public class InnerNodeMaxWeight
implements InnerNode {
    private int maxWeight;

    public InnerNodeMaxWeight() {
        this.setup();
    }

    @Override
    public void setup() {
        this.maxWeight = -1;
    }

    @Override
    public void updateValue(KPItem item) {
        if (item.isActive()) {
            this.maxWeight = Math.max(item.getWeight(), this.maxWeight);
        }
    }

    @Override
    public int getWeight() {
        return this.maxWeight;
    }

    @Override
    public void updateValue(InnerNode node) {
        try {
            InnerNodeMaxWeight nodeMaxWeight = (InnerNodeMaxWeight)node;
            this.maxWeight = Math.max(nodeMaxWeight.getWeight(), this.maxWeight);
        }
        catch (Exception e) {
            throw new RuntimeException("updateValue of InnerNode used with another type ");
        }
    }

    @Override
    public boolean isActive() {
        return this.maxWeight != -1;
    }

    public String toString() {
        return "w=" + this.maxWeight;
    }
}

