/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.Validate;
import java.io.File;
import java.util.Map;

public final class Par {
    private final String[] args;
    private final File gt;
    private final File gl;
    private final File gtgl;
    private final File ref;
    private final File dag;
    private final String out;
    private final File excludesamples;
    private final File excludemarkers;
    private final File ped;
    private final File map;
    private final String chrom;
    private final float maxlr;
    private final int nthreads;
    private final boolean lowmem;
    private final int window;
    private final int overlap;
    private final boolean impute;
    private final boolean gprobs;
    private final int niterations;
    private final float mapscale;
    private final float ne;
    private final float err;
    private final float cluster;
    private final long seed;
    private final boolean ibd;
    private final float ibdlod;
    private final float ibdcm;
    private final float ibdscale;
    private final int ibdtrim;
    private final float modelscale;
    private final int burnin_its;
    private final int phase_its;
    private final int nsamples;
    private final float ibdlength;
    private final float ibdextend;

    public Par(String[] stringArray) {
        int n = Integer.MAX_VALUE;
        long l = Long.MIN_VALUE;
        long l2 = Long.MAX_VALUE;
        float f = Float.MIN_VALUE;
        float f2 = Float.MAX_VALUE;
        this.args = (String[])stringArray.clone();
        Map<String, String> map = Validate.argsToMap(stringArray, '=');
        this.gt = Validate.getFile(Validate.stringArg("gt", map, false, null, null));
        this.gl = Validate.getFile(Validate.stringArg("gl", map, false, null, null));
        this.gtgl = Validate.getFile(Validate.stringArg("gtgl", map, false, null, null));
        this.ref = Validate.getFile(Validate.stringArg("ref", map, false, null, null));
        this.dag = Validate.getFile(Validate.stringArg("dag", map, false, null, null));
        this.out = Validate.stringArg("out", map, true, null, null);
        this.excludesamples = Validate.getFile(Validate.stringArg("excludesamples", map, false, null, null));
        this.excludemarkers = Validate.getFile(Validate.stringArg("excludemarkers", map, false, null, null));
        this.ped = Validate.getFile(Validate.stringArg("ped", map, false, null, null));
        this.map = Validate.getFile(Validate.stringArg("map", map, false, null, null));
        this.chrom = Validate.stringArg("chrom", map, false, null, null);
        this.maxlr = Validate.floatArg("maxlr", map, false, 5000.0f, 1.1f, f2);
        this.nthreads = Par.modNthreads(Validate.intArg("nthreads", map, false, n, 0, n));
        this.lowmem = Validate.booleanArg("lowmem", map, false, true);
        this.window = Validate.intArg("window", map, false, 50000, 1, n);
        this.overlap = Validate.intArg("overlap", map, false, 3000, 0, n);
        this.niterations = Validate.intArg("niterations", map, false, 5, 0, n);
        this.impute = Validate.booleanArg("impute", map, false, true);
        this.gprobs = Validate.booleanArg("gprobs", map, false, false);
        this.ne = Validate.floatArg("ne", map, false, 1000000.0f, f, f2);
        this.err = Validate.floatArg("err", map, false, 1.0E-4f, 0.0f, f2);
        this.cluster = Validate.floatArg("cluster", map, false, 0.005f, 0.0f, f2);
        this.seed = Validate.longArg("seed", map, false, -99999L, l, l2);
        this.ibd = Validate.booleanArg("ibd", map, false, false);
        this.ibdlod = Validate.floatArg("ibdlod", map, false, 3.0f, f, f2);
        this.ibdcm = Validate.floatArg("ibdcm", map, false, 1.5f, f, f2);
        this.ibdscale = Validate.floatArg("ibdscale", map, false, 0.0f, 0.0f, f2);
        this.ibdtrim = Validate.intArg("ibdtrim", map, false, 40, 0, n);
        this.modelscale = Validate.floatArg("modelscale", map, false, 0.8f, f, f2);
        this.burnin_its = 5;
        this.phase_its = 5;
        this.nsamples = 4;
        this.mapscale = Validate.floatArg("mapscale", map, false, 1.0f, f, f2);
        this.ibdlength = Validate.floatArg("ibdlength", map, false, 0.07f, f, f2);
        this.ibdextend = Validate.floatArg("ibdextend", map, false, 0.13f, 0.0f, f2);
        Validate.confirmEmptyMap(map);
    }

    public String[] args() {
        return (String[])this.args.clone();
    }

    public static String usage() {
        String string = Const.nl;
        return "Command line syntax: java -jar beagle.08Jun17.d8b.jar [arguments]" + string + string + "data input/output parameters ..." + string + "  gt=<VCF file: use GT field>                        (optional)" + string + "  gl=<VCF file: use GL/PL field>                     (optional)" + string + "  gtgl=<VCF file: use GT (preferred) or GL/PL field> (optional)" + string + "  ref=<VCF file with phased genotypes>               (optional)" + string + "  out=<output file prefix>                           (required)" + string + "  excludesamples=<file with 1 sample ID per line>    (optional)" + string + "  excludemarkers=<file with 1 marker ID per line>    (optional)" + string + "  map=<PLINK map file with cM units>                 (optional)" + string + "  chrom=<[chrom] or [chrom]:[start]-[end]>           (optional)" + string + "  maxlr=<max GL/PL likelihood ratio>                 (default=5000)" + string + string + "general parameters ..." + string + "  nthreads=<number of threads>                       (default: machine-dependent)" + string + "  lowmem=<use low-memory algorithm (true/false)>     (default=false)" + string + "  window=<markers per window>                        (default=50000)" + string + "  overlap=<overlap between windows>                  (default=3000)" + string + "  seed=<random seed>                                 (default=-99999)" + string + string + "phasing and imputation parameters ..." + string + "  niterations=<number of phasing iterations>         (default=5)" + string + "  impute=<impute ungenotyped markers (true/false)>   (default=true)" + string + "  gprobs=<print GP field for imputed markers>        (default=false)" + string + "  ne=<effective population size>                     (default=1000000)" + string + "  err=<allele miscall rate>                          (default=0.0001)" + string + "  cluster=<max cM in a marker cluster>               (default=0.005)" + string + string + "IBD parameters ..." + string + "  ibd=<perform IBD detection (true/false)>           (default=false)" + string + "  ibdlod=<min LOD score of reported IBD segments>    (default=3.0)" + string + "  ibdcm=<min cM length of reported IBD segments>     (default=1.5)" + string + "  ibdscale=<model scale factor for Refined IBD>      (default: data-dependent)" + string + "  ibdtrim=<markers at each segment end>              (default=40)" + string;
    }

    public float adjustedIbdScale(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (this.ibdscale == 0.0f) {
            return Math.max(2.0f, (float)Math.sqrt((double)n / 100.0));
        }
        return this.ibdscale;
    }

    private static int modNthreads(int n) {
        if (n == Integer.MAX_VALUE) {
            return Runtime.getRuntime().availableProcessors();
        }
        return n;
    }

    public File gt() {
        return this.gt;
    }

    public File gl() {
        return this.gl;
    }

    public File gtgl() {
        return this.gtgl;
    }

    public File ref() {
        return this.ref;
    }

    public File dag() {
        return this.dag;
    }

    public String out() {
        return this.out;
    }

    public File excludesamples() {
        return this.excludesamples;
    }

    public File excludemarkers() {
        return this.excludemarkers;
    }

    public File ped() {
        return this.ped;
    }

    public File map() {
        return this.map;
    }

    public String chrom() {
        return this.chrom;
    }

    public float maxlr() {
        return this.maxlr;
    }

    public int nthreads() {
        return this.nthreads;
    }

    public boolean lowmem() {
        return this.lowmem;
    }

    public int window() {
        return this.window;
    }

    public int overlap() {
        return this.overlap;
    }

    public long seed() {
        return this.seed;
    }

    public int niterations() {
        return this.niterations;
    }

    public boolean impute() {
        return this.impute;
    }

    public boolean gprobs() {
        return this.gprobs;
    }

    public float ne() {
        return this.ne;
    }

    public float err() {
        return this.err;
    }

    public float cluster() {
        return this.cluster;
    }

    public boolean ibd() {
        return this.ibd;
    }

    public float ibdlod() {
        return this.ibdlod;
    }

    public float ibdcm() {
        return this.ibdcm;
    }

    public float ibdscale() {
        return this.ibdscale;
    }

    public int ibdtrim() {
        return this.ibdtrim;
    }

    public float modelscale() {
        return this.modelscale;
    }

    public int burnin_its() {
        return this.burnin_its;
    }

    public int phase_its() {
        return this.phase_its;
    }

    public int nsamples() {
        return this.nsamples;
    }

    public float mapscale() {
        return this.mapscale;
    }

    public float ibdlength() {
        return this.ibdlength;
    }

    public float ibdextend() {
        return this.ibdextend;
    }
}

