/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.app.gui.ColorFunction;
import dr.geo.GTOPO30Panel;
import dr.geo.InhomogeneousRandomWalk;
import dr.geo.Location;
import dr.geo.RateMatrix;
import java.awt.Color;
import java.io.IOException;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class GTOPO30RandomWalk {
    public static void main(String[] stringArray) throws IOException {
        Color[] colorArray = new Color[]{Color.blue, Color.yellow, Color.green.darker(), Color.orange.darker(), Color.white, Color.pink};
        ColorFunction colorFunction = new ColorFunction(colorArray, new float[]{-410.0f, 0.0f, 100.0f, 1500.0f, 4000.0f, 8800.0f});
        GTOPO30Panel gTOPO30Panel = new GTOPO30Panel(stringArray, colorFunction);
        Random random = new Random();
        RateMatrix rateMatrix = gTOPO30Panel.getRates(100.0);
        gTOPO30Panel.setSize(gTOPO30Panel.latticeWidth(), gTOPO30Panel.latticeHeight());
        gTOPO30Panel.layout();
        InhomogeneousRandomWalk inhomogeneousRandomWalk = new InhomogeneousRandomWalk(gTOPO30Panel, new Location(0, 0), random, rateMatrix);
        Location location = gTOPO30Panel.getLocation(41.9, 12.5);
        System.out.println("Start = " + location);
        for (int i = 0; i < 1000; ++i) {
            inhomogeneousRandomWalk.simulate(location, 25000.0);
        }
        JFrame jFrame = new JFrame();
        JScrollPane jScrollPane = new JScrollPane(inhomogeneousRandomWalk);
        jFrame.getContentPane().add("Center", jScrollPane);
        jFrame.setSize(1800, 1100);
        jFrame.setVisible(true);
    }
}

