## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)


## ----setup--------------------------------------------------------------------
library(blockr.dag)
library(blockr.core)
library(blockr.dock)


## -----------------------------------------------------------------------------
# Create an empty board.
serve(new_dock_board(extensions = new_dag_extension()))


## -----------------------------------------------------------------------------
graph <- new_graph(
  nodes = list(
    list(id = 1),
    list(id = 2)
  ),
  edges = list(
    list(
      source = 1,
      target = 2,
      style = list(labelText = "1-2")
    )
  )
)

serve(
  new_dock_board(
    extensions = new_dag_extension(graph)
  )
)


## graph TD
##     subgraph Core Layer
##         blockr.core[blockr.core]
##     end
## 
##     subgraph Extension Blocks
##         blockr.dplyr[blockr.dplyr]
##         blockr.ggplot[blockr.ggplot]
##     end
## 
##     subgraph UI Layer
##         blockr.dock[blockr.dock]
##         blockr.dag[blockr.dag]
##     end
## 
##     subgraph External Dependencies
##         dockViewR[dockViewR]
##         g6R[g6R]
##     end
## 
##     blockr.core --> blockr.dock
##     blockr.dock --> blockr.dag
##     dockViewR --> blockr.dock
##     g6R --> blockr.dag
## 
##     blockr.core --> blockr.dplyr
##     blockr.core --> blockr.ggplot
## 
##     blockr.dplyr -.-> blockr.dock
##     blockr.dplyr -.-> blockr.dag
##     blockr.ggplot -.-> blockr.dock
##     blockr.ggplot -.-> blockr.dag

## -----------------------------------------------------------------------------
# Update observer handles board changes
update_observer <- function(update, board, proxy) {
  observeEvent(update(), {
    upd <- update()

    if (length(upd$blocks$add)) {
      add_nodes(upd$blocks$add, board$board, proxy)
    }

    if (length(upd$stacks$mod)) {
      update_combos(upd$stacks$mod, board$board, proxy)
    }

    # Handle other update types...
  })
}

