% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_spec.R
\name{column_spec}
\alias{column_spec}
\title{Specify the look of the selected column}
\usage{
column_spec(kable_input, column, width = NULL, bold = FALSE,
  italic = FALSE, monospace = FALSE)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{column}{A numeric value indicating which column to be selected. When
you do the counting, ignore the extra header columns you added through
add_header_left.}

\item{width}{A character string telling HTML & LaTeX how wide the column
needs to be, e.g. "10cm", "3in" or "30em".}

\item{bold}{A T/F value to control whether the text of the selected column
need to be bolded.}

\item{italic}{A T/F value to control whether the text of the selected column
need to be emphasized.}

\item{monospace}{A T/F value to control whether the text of the selected column
need to be monospaced (verbatim)}
}
\description{
This function allows users to select a column and then specify
its look. Right now it supports the following three properties: column width,
bold text and italic text.
}
\examples{
x <- knitr::kable(head(mtcars), "html")
column_spec(x, 1, width = "20em", bold = TRUE, italic = TRUE)

}
