% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.R
\name{BestTau}
\alias{BestTau}
\title{Find the best tau for exponential filtering detrend.}
\usage{
BestTau(arr3d, mst = NULL, tol = 1)
}
\arguments{
\item{arr3d}{A 3-dimensional array (the image stack) where the \eqn{n}th
slice is the \eqn{n}th image in the time series. To perform this on a file
that has not yet been read in, set this argument to the path to that file
(a string).}

\item{mst}{Do you want to apply an intensity threshold prior to calculating
brightness (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your
thresholding \emph{method} here.}

\item{tol}{What size of error in the estimate of the \emph{ideal} \code{tau}
(aside from the error introduced by the random image simulation, see
\code{vignette('AdaptiveDetrend', package = 'nandb')}) are you willing
to tolerate? The default is 1.}
}
\value{
A number. The estimate of the ideal \code{tau} to use, with an
attribute '\code{brightness.immobile}' giving the brightness of the
simulated (from all immobile particles) image series after detrending with
this \code{tau} (this should be very close to 1).
}
\description{
Say you have an image series that you wish to detrend before performing a
brightness calculation. This function finds the best \code{tau} for an
exponential filtering detrend. See \code{vignette('Adaptive Detrending',
package = 'nandb')} for more details.
}
\examples{
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
BestTau(img, tol = 3)

}
