% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmers.R
\name{KmerTIFFsFromBrightnessCSVs}
\alias{KmerTIFFsFromBrightnessCSVs}
\title{Create kmer tiff files from brightness csvs}
\usage{
KmerTIFFsFromBrightnessCSVs(monomer, csv.paths = NULL, out.names = NULL,
  na = "saturate", mcc = parallel::detectCores(), verbose = TRUE)
}
\arguments{
\item{monomer}{The (median) brightness of a monomer.}

\item{csv.paths}{The paths to the brightness csv files, defaults to
\code{list.files(pattern = '[Bb]rightness.*\\.csv')}.}

\item{out.names}{The names you want the output files to have (will be forced
to .tif).}

\item{na}{See \code{\link[=WriteIntImage]{WriteIntImage()}}.}

\item{mcc}{The number of parallel cores to use for the processing.}

\item{verbose}{Do you want to print a message when the function is done?}
}
\description{
For each brightness csv image in a folder, given a monomeric brightness,
create a tiff file of the kmer positions using \code{\link[=KmerArray]{KmerArray()}}.
}
\examples{
img <- system.file('extdata', '50.tif', package = 'nandb')
setwd(tempdir())
file.copy(img, ".")
BrightnessTxtFolder()
KmerTIFFsFromBrightnessCSVs(1.111)
file.remove(list.files())  # cleanup

}
