% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier.R
\name{switch_key}
\alias{switch_key}
\title{Switch to a different key of a cubble}
\usage{
switch_key(data, key)
}
\arguments{
\item{data}{a cubble object, can be either long or nested cubble}

\item{key}{the new key}
}
\value{
a cubble object
}
\description{
\code{switch_key()} allows you select a new variable in the data to become the key.
This can be used to create hierarchical data where one variable is nested in another.
}
\examples{
library(ggplot2)
library(dplyr)
# create an artificial cluster for stations
set.seed(1234)
cb <- climate_flat \%>\%
  as_cubble(key = id, index = date, coords = c(long, lat)) \%>\%
  mutate(cluster = sample(1:3, 1))

# switch the key to cluster
cb_hier <- cb \%>\%  switch_key(cluster)
}
