context("Test datePart")
test_that("Parameters are checked", {
    expect_error(datePart("2012-06-23", "2012-06-23", "D", "xx"), "Error in match.arg.*")
})

test_that("Extraction works as expected", {
    expect_equal(datePart("2012-06-23", "2012-06-23", "D"), 2012)    
    expect_equal(datePart("2012-06-23", "2012-06-23", "D", "year"), 2012)    
    expect_equal(datePart("2012-06-23", "2012-06-23", "D", "m"), 6)    
    expect_equal(datePart("2012-06-23", "2012-06-23", "D", "day"), 174)    
    expect_equal(datePart("2012-06-23", "2012-06-23", "D", "w"), 24)    
    expect_equal(datePart("2012-06-23", "2012-06-30", "DD", "day"), -1)    
    expect_equal(datePart("2012-06-23", "2012-06-30", "DD", "month"), 6)    
    expect_equal(datePart("2012-01-01", "2012-12-31", "Y"), 2012)    
    expect_equal(datePart("2010-01-01", "2012-12-31", "YY"), 2012)    
    expect_equal(datePart("2012-01-01", "2012-12-31", "Y", "m"), -1)    
    expect_equal(datePart("", "", "U", "year"), -1)    
    expect_equal(datePart("1912-01-01", "1912-12-31", "Y"), 1912)    
    expect_equal(datePart("1873-06-23", "1873-06-23", "D", "day"), 173)    
    expect_equal(datePart("2012-06-01", "2012-06-30", "O", "m"), 6)    
    expect_equal(datePart("2012-06-01", "2012-06-30", "O", "d"), -1)    
    expect_equal(datePart("2012-06-01", "2012-08-31", "OO", "m"), -1)    
    expect_equal(datePart("2012-06-01", "2012-08-31", "OO", "year"), 2012)    
    expect_equal(datePart("1912-01-01", "1912-12-31", "P"), 1912)    
})
