% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcohtest.R
\name{fastcohtest}
\alias{fastcohtest}
\title{Fast algorithm for significance testing coherence using Fourier surrogates}
\usage{
fastcohtest(dat1, dat2, scale.min, scale.max.input, sigma, f0, nrand, randnums,
  randbits, norm)
}
\arguments{
\item{dat1}{A locations (rows) x time (columns) matrix (for spatial coherence), or a single time series}

\item{dat2}{Same format as \code{dat1}, same locations and times}

\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation guaranteed to be examined}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Should be greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelope}

\item{nrand}{Number of surrogate randomizations to use for significance testing}

\item{randnums}{A bunch of independent random numbers uniformly distributed on (0,1).
There must be \code{nrand*floor((dim(dat1)[2]-1)/2)} of these.}

\item{randbits}{A bunch of random bits (0 or 1). There must be \code{nrand} of these if time
series are of odd length and \code{2*nrand} if even length. You may pass more than this, so,
in particular, you may pass \code{2*nrand} for even or odd length.}

\item{norm}{The normalization of wavelet transforms to use. Controls the version of the 
coherence that is performed. One of "none", "powall", "powind". See details in
the documentation of \code{coh}.}
}
\value{
\code{fastcohtest} returns a list with these elements:
\item{timescales}{The timescales used}
\item{coher}{The magnitude of this is the fast-algorithm version of the coherence between
the two datasets, for comparison with \code{scoher}}
\item{scoher}{A matrix with \code{nrand} rows, the magnitude of each one is the 
fast-algorithm version of the coherence for a surrogate}
}
\description{
This is the algorithm of Sheppard et al. (2017) (see references).
}
\note{
Internal function, minimal error checking.
}
\references{
Sheppard, L.W., et al. (2017) Rapid surrogate testing of wavelet coherences. European Physical 
Journal, Nonlinear and Biomedical Physics, 5, 1. DOI: 10.1051/epjnbp/2017000
}
\author{
Lawrence Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
