test_that("simulate_stream runs with defaults", {
  sim <- simulate_stream()
  expect_type(sim, "list")
  expect_named(sim, c("x", "y"))

  # Lengths match
  expect_equal(length(sim$x), nrow(sim$y))

  # States are in {1,2,3}
  expect_true(all(sim$x %in% 1:3))

  # Matrix has correct dimensions
  expect_equal(ncol(sim$y), 10)
})

test_that("simulate_stream respects dimensions", {
  sim <- simulate_stream(d = 5, TT = 200, T0 = 50)
  expect_equal(ncol(sim$y), 5)
  expect_equal(length(sim$x), 250)
  expect_equal(nrow(sim$y), 250)
})

test_that("simulate_stream errors with inconsistent means/covariances", {
  bad_means <- list(rep(0, 2), rep(0, 2)) # wrong length
  expect_error(simulate_stream(p = 2, means = bad_means, covariances = NULL))

  bad_cov <- list(diag(2), diag(2), matrix(1,2,2)) # not symmetric
  bad_cov[[3]][1,2] <- 2
  expect_error(simulate_stream(p = 2, means = list(rep(0,2), rep(0,2), rep(0,2)),
                                covariances = bad_cov))
})

