% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_sumstats.R
\name{CalcSumstats}
\alias{CalcSumstats}
\title{Calculate Summary Statistics}
\usage{
CalcSumstats(
  anno = NULL,
  covar = NULL,
  data = NULL,
  geno = NULL,
  pheno = NULL,
  add_intercept = TRUE,
  is_binary = FALSE
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector.}

\item{covar}{(subjects x covars) covariate matrix.}

\item{data}{List of data containing the annotation vector \code{anno}, the
covariate data \code{covar}, the genotype matrix \code{geno}, and the phenotype
vector \code{pheno}, as returned by \code{\link{DGP}}. Overrides the other
arguments if provided.}

\item{geno}{(subjects x snps) genotype matrix.}

\item{pheno}{(subjects x 1) phenotype vector.}

\item{add_intercept}{Add an intercept if not present in the supplied
covariate matrix covar? Default: TRUE.}

\item{is_binary}{Is the phenotype binary? Default: FALSE.}
}
\value{
List containing the following items:
\itemize{
\item \code{ld}: A SNP x SNP correlation (LD) matrix.
\item \code{sumstats}: A SNP x 5 matrix of summary statistics, including the
.  annotation, MAF, estimated effect size, standard error, and p-value.
\item \code{type}: Either "binary" or "quantitative".`
}
}
\description{
Generate summary statistics from individual-level data. Provide either a
list of data as generated by \code{\link{DGP}}, or all of \code{anno}, \code{geno},
and \code{pheno}.
}
\examples{
data <- DGP()
sumstats <- CalcSumstats(data = data)
}
