% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.mlergm.R
\name{gof.mlergm}
\alias{gof.mlergm}
\title{Evaluate the goodness-of-fit of an estimated model.}
\usage{
\method{gof}{mlergm}(object, ..., options = set_options(), seed = NULL, gof_form = NULL)
}
\arguments{
\item{object}{An object of class \code{\link{mlergm}}, likely produced by function \code{\link{mlergm}}.}

\item{\dots}{Additional arguments to be passed if necessary.}

\item{options}{See \code{\link{set_options}} for details.}

\item{seed}{A seed to be provided to ensure reproducibility of results.}

\item{gof_form}{A formula object of the form \code{~ term1 + term2 + ...} for statistics to compute for the GOF procedure.}
}
\value{
\code{\link{gof.mlergm}} returns an object of class \code{gof_mlergm} which is a list containing:
\item{obs_stats}{The GOF statistic values of the observed network.}
\item{gof_stats}{The GOF statistic values simulated from the the estimated \code{mlergm} objeect provided.}
}
\description{
Performs a Goodness-of-Fit procedure along the lines of 
Hunter, Goodreau, and Handcock (2008). Statistics are simulated 
from an fitted \code{mlergm} object, which can then be plotted and visualized.  
An example is given in the documentation of \code{\link{mlergm}}.
}
\references{
Hunter, D. R.,  Goodreau, S. M., and Handcock, M. S. (2008). 
Goodness of fit of social network models. 
Journal of the American Statistical Association, 103(481), 248-258.
}
\seealso{
\code{\link{plot.gof_mlergm}}
}
\keyword{estimation}
