% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_presidential_events.R
\name{get_presidential_events}
\alias{get_presidential_events}
\title{Get Presidential Events in Argentina}
\usage{
get_presidential_events()
}
\value{
A data frame (tibble) with the following columns:
\itemize{
  \item \code{fecha}: Date of the event (character, format YYYY-MM-DD).
  \item \code{tipo}: Type of event (e.g., speech, announcement).
  \item \code{evento}: Description or name of the event.
}
}
\description{
This function retrieves the list of presidential events in Argentina from the API
`https://api.argentinadatos.com/v1/eventos/presidenciales`. It returns a structured data frame
with the event date, type, and description.
}
\details{
This function sends a GET request to the ArgentinaDatos API and processes the JSON response into
a structured data frame. The events are not filtered by year and include all available historical data.
If the API does not return a 200 status code, a message is displayed and \code{NULL} is returned.
}
\note{
Requires internet connection. If the API becomes unavailable or changes, the function may need updates.
}
\examples{
\dontrun{
# Retrieve presidential events
events <- get_presidential_events()
print(events)

# View only events after 2020
events \%>\%
  dplyr::filter(fecha >= "2020-01-01")
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}
}
