% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/price_impact_utils.R
\name{check_no_arbitrage}
\alias{check_no_arbitrage}
\title{Check No-Arbitrage Condition}
\usage{
check_no_arbitrage(r, u, d, lambda, v_u, v_d)
}
\arguments{
\item{r}{Gross risk-free rate per period}

\item{u}{Base up factor}

\item{d}{Base down factor}

\item{lambda}{Price impact coefficient}

\item{v_u}{Hedging volume on up move}

\item{v_d}{Hedging volume on down move}
}
\value{
Logical: TRUE if condition holds, FALSE otherwise
}
\description{
Verifies that the no-arbitrage condition
\eqn{\tilde{d} < r < \tilde{u}} holds.
}
\examples{
check_no_arbitrage(r = 1.05, u = 1.2, d = 0.8, lambda = 0.1, v_u = 1, v_d = 1)
}
