% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictability.R
\name{plot.predictability}
\alias{plot.predictability}
\title{Plot \code{predictability} Objects}
\usage{
\method{plot}{predictability}(
  x,
  type = "error_bar",
  cred = 0.95,
  alpha = 0.5,
  scale = 1,
  width = 0,
  size = 1,
  color = "blue",
  ...
)
}
\arguments{
\item{x}{An object of class \code{predictability}}

\item{type}{Character string. Which type of plot ? The options
are \code{"error_bar"} or \code{"ridgeline"} (defaults to \code{"error_bar"}).}

\item{cred}{Numeric. The credible interval width for summarizing the posterior
distributions (defaults to 0.95; must be between 0 and 1).}

\item{alpha}{Numeric. Transparancey of the ridges}

\item{scale}{Numeric. This controls the overlap of densities
for \code{type = "ridgeline"} (defaults to 1).}

\item{width}{Numeric. The width of error bar ends (defaults to \code{0})
for \code{type = "error_bar"}.}

\item{size}{Numeric. The size for the points (defaults to \code{2})
for \code{type = "error_bar"}.}

\item{color}{Character string. What color for the point (\code{type = "error_bar"}) or
tail region (\code{type = "ridgeline"} ) ? Defaults to \code{"blue"}.}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{ggplot}.
}
\description{
Plot \code{predictability} Objects
}
\examples{
\donttest{
Y <- ptsd[,1:5]

fit <- explore(Y, iter = 250,
               progress = FALSE)

r2 <- predictability(fit, iter = 250,
                     progress = FALSE)

plot(r2)

}
}
