% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.bold.analyze.map.R
\name{bold.analyze.map}
\alias{bold.analyze.map}
\title{Visualize BIN occurrence data on maps}
\usage{
bold.analyze.map(bold_df, country = NULL, bbox = NULL)
}
\arguments{
\item{bold_df}{The data.frame retrieved from \code{\link[=bold.fetch]{bold.fetch()}}.}

\item{country}{A single or multiple character vector of country names. Default value is NULL.}

\item{bbox}{A numeric vector specifying the min, max values of the latitude and longitude. Default value is NULL.}
}
\value{
An 'output' list containing:
\itemize{
\item geo.df = A simple features (sf) ‘data.frame’ containing the geographic data.
\item plot = A visualization of the occurrences.
}
}
\description{
This function creates basic maps of BIN occurrences at different scales.
}
\details{
\code{bold.analyze.map} extracts out the geographic information from the \code{\link[=bold.fetch]{bold.fetch()}} output to generate an occurrence map. Data points having NA values for either latitude or longitude or both are removed. Latitude and longitude values are in ‘decimal degrees’ format with a ’WGS84’ Coordinate Reference System (CRS) projection. Default view includes data mapped onto a world shape file using the \code{rnaturalearth::ne_countries()} at a 110 scale (low resolution). If the country is specified (single or multiple values), the function will specifically plot the occurrences on the specified country. Alternatively, a bounding box (bbox) can be defined for a specific region to be visualized (First two elements of the bbox are longitude values (xmin and xmax) and the remaining two are latitude values (ymin and ymax)). The function also provides a \code{sf} data frame of the GIS data which can be used for any other application/s. For names of countries, please refer to \url{https://www.geonames.org/}.
}
\examples{
\dontrun{
#Download the ids
geo_data.ids <- bold.public.search(taxonomy = list("Musca domestica"))

# Fetch the data using the ids.
#1. api_key must be obtained from BOLD support before using `bold.fetch()` function.
#2. Use the `bold.apikey()` function  to set the apikey in the global env.

bold.apikey('apikey')

geo_data <- bold.fetch(get_by = "processid",
                       identifiers = geo_data.ids$processid)

# All data plotted.
geo.viz <- bold.analyze.map(geo_data)
# View plot
geo.viz$plot

# Data plotted only in one country
geo.viz.country <- bold.analyze.map(geo_data,
                                    country = c("Saudi Arabia"))
# View plot
geo.viz.country$plot
# The sf dataframe of the downloaded data
geo.viz$geo.df

# Data plotted based on a bounding box
bold.analyze.map(bold_df = geo_data,
bbox = c(41,100,20.36501,55.506))
}

}
