% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indbcomp.R
\name{indbcomp}
\alias{indbcomp}
\title{Comparing Independent Coefficients in Multiple Regression}
\usage{
indbcomp(model1 = NULL, model2 = NULL, comps = "abs", pred = NULL)
}
\arguments{
\item{model1}{Summary of first model (see example for how to summarize)}

\item{model2}{Summary of second model (see example for how to summarize)}

\item{comps}{Type of comparison. "abs" - absolute value of coefficient}

\item{pred}{Number of predictors}
}
\value{
Comparing Independent Coefficients in Multiple Regression
}
\description{
Comparing Independent Coefficients in Multiple Regression
}
\examples{
y_1<-rnorm(200); x1_1<-rnorm(200); x2_1<-rnorm(200)
y_2<-rnorm(200); x1_2<-rnorm(200);x2_2<-rnorm(200)
df1<-as.data.frame(cbind(y_1, x1_1,x2_1))
df2<-as.data.frame(cbind(y_2, x1_2,x2_2))
model1_2<-summary(lm(y_1~x1_1+x2_1, data=df1))
model2_2<-summary(lm(y_2~x1_2+x2_2, data=df2))
indbcomp(model1 = model1_2, model2 = model2_2, comps="abs", pred=2)
}
