% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-plot.R
\docType{methods}
\name{S4BuyseTest-plot}
\alias{S4BuyseTest-plot}
\alias{plot,S4BuyseTest,ANY-method}
\title{Graphical Display for GPC}
\usage{
\S4method{plot}{S4BuyseTest,ANY}(
  x,
  type = "hist",
  strata = "global",
  endpoint = NULL,
  label.strata = NULL,
  label.endpoint = NULL,
  plot = TRUE,
  color = c("#7CAE00", "#F8766D", "#C77CFF", "#00BFC4"),
  ...
)
}
\arguments{
\item{x}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{type}{[character] type of plot: histogram (\code{"hist"}), pie chart (\code{"pie"}), or nested pie charts (\code{"racetrack"}).}

\item{strata}{[character vector] strata(s) relative to which the percentage should be displayed.}

\item{endpoint}{[character vector] endpoint(s) relative to which the percentage should be displayed.}

\item{label.strata}{[character vector] new labels for the strata levels. Should match the length of argument \code{strata}.}

\item{label.endpoint}{[character vector] new labels for the endpoints. Should match the length of argument \code{endpoint}.}

\item{plot}{[logical] should the graphic be displayed in a graphical window.}

\item{color}{[character vector] colors used to display the percentages for each type of pair.}

\item{...}{not used, for compatibility with the generic function.}
}
\value{
an invisible list containing the data and the ggplot object used for graphical display.
}
\description{
Graphical display of the percentage of favorable, unfavorable, neutral, and uninformative pairs per endpoint.
}
\examples{
if(require(ggplot2)){

## simulate data
set.seed(10)
df.data <- simBuyseTest(1e2, n.strata = 2)

ff1 <- treatment ~ bin(toxicity) + TTE(eventtime, status = status,
                                      restriction = 1, threshold = 0.5)
BT1 <- BuyseTest(ff1, data= df.data)
plot(BT1, type = "hist")
plot(BT1, type = "pie")
plot(BT1, type = "racetrack")

ff2 <- update(ff1, ~.+cont(score))
BT2 <- BuyseTest(ff2, data= df.data)
plot(BT2, type = "hist")
plot(BT2, type = "pie")
plot(BT2, type = "racetrack")

}
}
\keyword{hplot}
