% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-BuyseTest-sensitivity.R
\docType{methods}
\name{sensitivity}
\alias{sensitivity}
\alias{sensitivity,S4BuyseTest-method}
\title{Sensitivity Analysis for the Choice of the Thresholds}
\usage{
\S4method{sensitivity}{S4BuyseTest}(
  object,
  threshold,
  statistic = NULL,
  band = FALSE,
  conf.level = NULL,
  null = NULL,
  transformation = NULL,
  alternative = NULL,
  adj.p.value = FALSE,
  trace = TRUE,
  cpus = 1,
  ...
)
}
\arguments{
\item{object}{an \R object of class \code{\linkS4class{S4BuyseTest}}, i.e., output of \code{\link{BuyseTest}}}

\item{threshold}{[list] a list containing for each endpoint the thresholds to be considered.}

\item{statistic}{[character] the statistic summarizing the pairwise comparison: \code{"netBenefit"}, \code{"winRatio"}, \code{"favorable"}, \code{"unfavorable"}.
See the documentation of the \code{coef} method for further details.
Default value read from \code{BuyseTest.options()}.}

\item{band}{[logical] should simulateneous confidence intervals be computed?}

\item{conf.level}{[numeric] confidence level for the confidence intervals.
Default value read from \code{BuyseTest.options()}.}

\item{null}{[numeric] right hand side of the null hypothesis (used for the computation of the p-value).}

\item{transformation}{[logical]  should the CI be computed on the logit scale / log scale for the net benefit / win ratio and backtransformed.
Otherwise they are computed without any transformation.
Default value read from \code{BuyseTest.options()}. Not relevant when using permutations or percentile bootstrap.}

\item{alternative}{[character] the type of alternative hypothesis: \code{"two.sided"}, \code{"greater"}, or \code{"less"}.
Default value read from \code{BuyseTest.options()}.}

\item{adj.p.value}{[logical] should p-value adjusted for multiple comparisons be computed?}

\item{trace}{[logical] Should the execution of the function be traced?}

\item{cpus}{[integer, >0] the number of CPU to use. Default value is 1.}

\item{...}{argument passsed to the function \code{transformCIBP} of the riskRegression package.}
}
\value{
An S3 object of class \code{S3sensitivity}.
}
\description{
Evaluate a summary statistic (net benefit, win ratio, ...) using GPC along various thresholds of clinical relevance.
}
\details{
Simulateneous confidence intervals and adjusted p-values are computed using a single-step max-test approach via the function \code{transformCIBP} of the riskRegression package.
}
\examples{

\dontrun{
require(ggplot2)

## simulate data
set.seed(10)
df.data <- simBuyseTest(1e2, n.strata = 2)

## with one endpoint
ff1 <- treatment ~ TTE(eventtime, status = status, threshold = 0.1)
BT1 <- BuyseTest(ff1, data= df.data)
se.BT1 <- sensitivity(BT1, threshold = seq(0,2,0.25), band = TRUE)
plot(se.BT1)

## with two endpoints
ff2 <- update(ff1, .~. + cont(score, threshold = 1))
BT2 <- BuyseTest(ff2, data= df.data)
se.BT2 <- sensitivity(BT2, threshold = list(eventtime = seq(0,2,0.25), score = 0:2),
                      band = TRUE)
plot(se.BT2)
plot(se.BT2, col = NA)
}
}
\keyword{htest}
