% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{test_inputs}
\alias{test_inputs}
\title{Default input tests}
\usage{
test_inputs(use = "all", skip = "")
}
\arguments{
\item{use}{Names of input classes to use. Valid names are "all" (default),
"scalar", "numeric", "integer", "logical", "character", "factor",
"data.frame", "matrix", "array", "date", "raw", "na" and "list". A vector
of valid classes can be retrieved programmatically by setting this
argument to "help".}

\item{skip}{Names of input classes to skip.}
}
\value{
A named list of inputs corresponding to the input classes selected, or
a character vector of valid input classes if \code{use = "help"}.
}
\description{
This function provides a selection of potentially problematic inputs by
class. List inputs are very limited by design, as they can be automatically
generated by setting \code{listify_what = TRUE} in \link{fuzz}.
}
\examples{
## only the scalar and numeric tests
inputs1 <- test_inputs(use = c("scalar", "numeric"))

## everything but the data, raw and list tests
inputs2 <- test_inputs(skip = c("date", "raw", "list"))

## print the valid input classes
test_inputs("help")

}
\seealso{
\link{fuzz}
}
