% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_quant.R
\name{plot.thornthwaite}
\alias{plot.thornthwaite}
\title{Thornthwaite - Mather's quantile plot}
\usage{
\method{plot}{thornthwaite}(
  x,
  save_dir = NULL,
  format = NULL,
  variables = c("Precipitation", "Et0", "Storage", "Prec. - Evap.", "Deficit", "Surplus"),
  title = TRUE,
  trace_grid = TRUE,
  st_name = NULL,
  u_y_scale_magn = 0.2,
  l_y_scale_magn = 0,
  leg_pos = "topleft",
  ...
)
}
\arguments{
\item{x}{a list of quantile data frames of water balance variables to be plotted, as output of function \code{\link{thornthwaite}}.}

\item{save_dir}{name of destination directory for graphs (if any). Default is \code{NULL}.}

\item{format}{graphic format of graphs; default is NULL (charts are sent to console).}

\item{variables}{character vector of variables to be plotted.}

\item{title}{logic. If \code{TRUE} inserts titles in charts.}

\item{trace_grid}{logic. If \code{TRUE} (default) adds a grid.}

\item{st_name}{name to be included into graphs titles. If NULL (default), no title is written.}

\item{u_y_scale_magn}{magnification of range above upper limit, to set upper y-scale limit; default is 0.}

\item{l_y_scale_magn}{magnification of range below lower limit, to set lower y-scale limit; default is 0.1.}

\item{leg_pos}{legend position. Default is "topleft". If NULL, no legend is added.}

\item{...}{arguments to be passed to methods, such as graphical parameters (see \code{\link{par}}).}
}
\value{
Charts of quantiles for water balance variables (12-month climatic values). They can be sent to the console or saved as graphic files.
}
\description{
'plot' method implementation for 12-month quantile climate charts from output of function \code{\link{thornthwaite}} (Thornthwaite and Mather's water balance).
}
\details{
Default for plot variables is all those calculated by function thornthwaite: "Precipitation", "Et0", "Storage", "Prec. - Evap.", "Deficit", "Surplus". See function \code{\link{thornthwaite}} for details on variables.

If \code{format} is NULL (default), graphs are sent to the console. Otherwise, a file is produced and saved to the \code{save_dir} directory. Values allowed are: "png", "jpeg", "tiff", "bmp".

\code{l_y_scale_magn} and \code{u_y_scale_magn} are the magnification coefficients (lower and upper, respectively), for y scale. If rng is the range between maximum and minimum values in all sets of series within a plot, the lower limit for y scale will be (rng * \code{l_y_scale_magn}) below the lower value, and the upper limit will be (rng * \code{u_y_scale_magn}) above the upper value of series.

Allowed values for \code{leg_pos} are the same of \code{x} in function \code{\link{legend}}.

Most graphic parameters for functions \code{\link{plot}} and \code{\link{legend}} are accepted.
}
\note{
A conflict is generated if parameters already used by the function are passed (e.g. x for \code{\link{legend}}: use \code{leg_pos} instead).
}
\examples{

data(Trent_climate)


# quantiles is the list ("thornthwaite" S3 object)of quantile tables generated 
# by function thornthwaite; 
# it is the second element of the output list, 
# which can be split into two separate lists (see function thornthwaite)
sta <- 1     # 1st station in the list of quantile tables
q_list=quantiles[[sta]]
class(q_list) <- "thornthwaite" ## q_list is coerced to a "thornthwaite" S3 object
plot(q_list, 
st_name=names(quantiles)[sta], variables=c("Precipitation",  "Et0"), 
leg_pos = "topleft", col=c(1:6,1), pch=c(1:6,16),  
lty=1, horiz=TRUE,  y.intersp=0.1)

}
\seealso{
\code{\link{thornthwaite}}
}
\author{
Emanuele Eccel
}
