% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/padCohortDate.R
\name{padCohortEnd}
\alias{padCohortEnd}
\title{Add days to cohort end}
\usage{
padCohortEnd(
  cohort,
  days,
  collapse = TRUE,
  requireFullContribution = FALSE,
  cohortId = NULL,
  name = tableName(cohort),
  .softValidation = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{days}{Integer with the number of days to add or name of a column (that
must be numeric) to add.}

\item{collapse}{Whether to collapse the overlapping records (TRUE) or drop
the records that have an ongoing prior record.}

\item{requireFullContribution}{Whether to require individuals to contribute all
required days. If TRUE, those individuals for which adding days would take
them out of observation will be dropped. If FALSE, days will only be added
up to the day when the individual leaves observation.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
Cohort table
}
\description{
\code{padCohortEnd()} Adds (or subtracts) a certain number of days to the cohort
end date. Note:
\itemize{
\item If the days added means that cohort end would be after observation
period end date, then observation period end date will be used for cohort
exit.
\item If the days added means that cohort exit would be after the next cohort
start then these overlapping cohort entries will be collapsed.
\item If days subtracted means that cohort end would be before cohort start then
the cohort entry will be dropped.
}
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
# add 10 days to each cohort exit
cdm$cohort1 |>
  padCohortEnd(days = 10)
}
}
