% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultsDataModel.R
\name{uploadResults}
\alias{uploadResults}
\title{Upload results to the database server.}
\usage{
uploadResults(
  connectionDetails,
  schema,
  resultsFolder,
  forceOverWriteOfSpecifications = FALSE,
  purgeSiteDataBeforeUploading = TRUE,
  tablePrefix = "",
  ...
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package.}

\item{schema}{The schema on the server where the tables have been created.}

\item{resultsFolder}{The folder holding the results in .csv files}

\item{forceOverWriteOfSpecifications}{If TRUE, specifications of the phenotypes, cohort definitions, and analysis
will be overwritten if they already exist on the database. Only use this if these specifications
have changed since the last upload.}

\item{purgeSiteDataBeforeUploading}{If TRUE, before inserting data for a specific databaseId all the data for
that site will be dropped. This assumes the resultsFolder file contains the full data for that
data site.}

\item{tablePrefix}{(Optional)  string to insert before table names for database table names}

\item{...}{See ResultModelManager::uploadResults}
}
\description{
Requires the results data model tables have been created using the \code{\link{createResultsDataModel}} function.
}
