% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIPC.R
\name{DIPC}
\alias{DIPC}
\title{Distributed Incremental Principal Component Analysis (DIPC)}
\usage{
DIPC(data, m, eta, K)
}
\arguments{
\item{data}{Matrix of input data (n × p).}

\item{m}{Number of principal components.}

\item{eta}{Proportion of  initial batch to  total data  within each node.}

\item{K}{Number of nodes (distributed splits).}
}
\value{
List with per-node results and aggregated averages.
}
\description{
Apply IPC in a distributed manner across K nodes.
}
\examples{
library(LFM)
data_from_package <- Wine
data_a <- Wine
m=5
eta=0.8
K=2
results <- DIPC(data_a, m, eta, K)
}
