% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost.R
\name{cost}
\alias{cost}
\alias{costLS}
\alias{costARc}
\alias{costED}
\alias{costPL}
\alias{costLPL}
\alias{costBAR}
\title{Cost functions for DendSer
Each of these functions evaluates the cost of an ordering.}
\usage{
costLS(sw, o, target = seq_along(sw), ...)

costARc(sw, o, target = nrow(sw) - 1, ...)

costED(sw, o, node, se, ...)

costPL(sw, o, ...)

costLPL(sw, o, target = (nrow(sw) - 1):1, ...)

costBAR(sw, o, target = max(2, floor(nrow(sw)/5)), ...)
}
\arguments{
\item{sw}{For cost=costLS, this is a vector of object weights. Otherwise is
a symmetric matrix.}

\item{o}{An ordering vector.}

\item{target}{Parameter used by cost function.}

\item{\dots}{Other args.}

\item{node}{The node}

\item{se}{Extra info}
}
\value{
Result of cost
}
\description{
Cost functions for DendSer
Each of these functions evaluates the cost of an ordering.
}
\author{
Catherine Hurley & Denise Earle
}
