% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotDrugRestart}
\alias{plotDrugRestart}
\title{Generate a custom ggplot2 from a summarised_result object generated with
summariseDrugRestart() function.}
\usage{
plotDrugRestart(
  result,
  x = "variable_level",
  position = "stack",
  facet = cdm_name + cohort_name ~ follow_up_days,
  colour = "variable_level",
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Variable to plot on x-axis}

\item{position}{Position of bars, can be either \code{dodge} or \code{stack}}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}. If a character, this
may be either the name of a built-in style (see \code{plotStyle()}), or a path to
a \code{.yml} file that defines a custom style. If NULL, the function will use the
explicit default style, unless a global style option is set (see
\code{visOmopResults::setGlobalPlotOptions()}) or a \verb{_brand.yml} file is present
(in that order). Refer to the \strong{visOmopResults} package vignette on styles
to learn more.}
}
\value{
A ggplot2 object.
}
\description{
Generate a custom ggplot2 from a summarised_result object generated with
summariseDrugRestart() function.
}
\examples{
\dontrun{
library(DrugUtilisation)

cdm <- mockDrugUtilisation()

conceptlist <- list("a" = 1125360, "b" = c(1503297, 1503327))
cdm <- generateDrugUtilisationCohortSet(cdm = cdm,
                                        name = "switch_cohort",
                                        conceptSet = conceptlist)

result <- cdm$cohort1 |>
  summariseDrugRestart(switchCohortTable = "switch_cohort")

plotDrugRestart(result)

plotDrugRestart(result, x = "cohort_name", facet = "follow_up_days")
}

}
