% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R, R/group_design.R, R/priors.R,
%   R/s3_funcs.R
\name{sampled_pars}
\alias{sampled_pars}
\alias{sampled_pars.emc.design}
\alias{sampled_pars.emc.group_design}
\alias{sampled_pars.emc.prior}
\alias{sampled_pars.emc}
\title{Get Model Parameters from a Design}
\usage{
sampled_pars(
  x,
  group_design = NULL,
  doMap = FALSE,
  add_da = FALSE,
  all_cells_dm = FALSE,
  data = NULL
)

\method{sampled_pars}{emc.design}(
  x,
  group_design = NULL,
  doMap = FALSE,
  add_da = FALSE,
  all_cells_dm = FALSE,
  data = NULL
)

\method{sampled_pars}{emc.group_design}(
  x,
  group_design = NULL,
  doMap = FALSE,
  add_da = FALSE,
  all_cells_dm = FALSE,
  data = NULL
)

\method{sampled_pars}{emc.prior}(
  x,
  group_design = NULL,
  doMap = FALSE,
  add_da = FALSE,
  all_cells_dm = FALSE,
  data = NULL
)

\method{sampled_pars}{emc}(
  x,
  group_design = NULL,
  doMap = FALSE,
  add_da = FALSE,
  all_cells_dm = FALSE,
  data = NULL
)
}
\arguments{
\item{x}{an \code{emc.design} object made with \code{design()} or an \code{emc} object.}

\item{group_design}{an \code{emc.group_design} object made with \code{group_design()}}

\item{doMap}{logical. If \code{TRUE} will also include an attribute \code{map}
with the design matrices that perform the mapping back to the design}

\item{add_da}{Boolean. Whether to include the relevant data columns in the map attribute}

\item{all_cells_dm}{Boolean. Whether to include all levels of a factor in the mapping attribute,
even when one is dropped in the design}

\item{data}{A data frame to be included for accurate covariate mapping in summary.design}
}
\value{
Named vector.
}
\description{
Makes a vector with zeroes, with names and length corresponding to the
model parameters of the design.
}
\examples{
# First define a design
design_DDMaE <- design(data = forstmann,model=DDM,
                           formula =list(v~0+S,a~E, t0~1, s~1, Z~1, sv~1, SZ~1),
                           constants=c(s=log(1)))
# Then for this design get which cognitive model parameters are sampled:
sampled_pars(design_DDMaE)

}
