% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpiNow2-package.R
\docType{package}
\name{EpiNow2-package}
\alias{EpiNow2}
\alias{EpiNow2-package}
\title{EpiNow2: Estimate and Forecast Real-Time Infection Dynamics}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Estimates the time-varying reproduction number, rate of spread, and doubling time using a renewal equation approach combined with Bayesian inference via Stan. Supports Gaussian process and random walk priors for modelling changes in transmission over time. Accounts for delays between infection and observation (incubation period, reporting delays), right-truncation in recent data, day-of-week effects, and observation overdispersion. Can estimate relationships between primary and secondary outcomes (e.g., cases to hospitalisations or deaths) and forecast both. Runs across multiple regions in parallel. Based on Abbott et al. (2020) \doi{10.12688/wellcomeopenres.16006.1} and Gostic et al. (2020) \doi{10.1101/2020.06.18.20134858}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://epiforecasts.io/EpiNow2/}
  \item \url{https://epiforecasts.io/EpiNow2/dev/}
  \item \url{https://github.com/epiforecasts/EpiNow2}
  \item Report bugs at \url{https://github.com/epiforecasts/EpiNow2/issues}
}

}
\author{
\strong{Maintainer}: Sebastian Funk \email{sebastian.funk@lshtm.ac.uk} (\href{https://orcid.org/0000-0002-2842-3406}{ORCID})

Authors:
\itemize{
  \item Sam Abbott \email{sam.abbott@lshtm.ac.uk} (\href{https://orcid.org/0000-0001-8057-8037}{ORCID})
  \item Joel Hellewell \email{joel.hellewell@lshtm.ac.uk} (\href{https://orcid.org/0000-0003-2683-0849}{ORCID})
  \item Katharine Sherratt \email{katharine.sherratt@lshtm.ac.uk}
  \item Katelyn Gostic \email{kgostic@uchicago.edu}
  \item Joe Hickson \email{joseph.hickson@metoffice.gov.uk}
  \item Hamada S. Badr \email{badr@jhu.edu} (\href{https://orcid.org/0000-0002-9808-2344}{ORCID})
  \item Michael DeWitt \email{me.dewitt.jr@gmail.com} (\href{https://orcid.org/0000-0001-8940-1967}{ORCID})
  \item James M. Azam \email{james.azam@lshtm.ac.uk} (\href{https://orcid.org/0000-0001-5782-7330}{ORCID})
  \item Adrian Lison \email{adrian.lison@bsse.ethz.ch} (\href{https://orcid.org/0000-0002-6822-8437}{ORCID})
}

Other contributors:
\itemize{
  \item Robin Thompson \email{robin.thompson@lshtm.ac.uk} [contributor]
  \item Sophie Meakin \email{sophie.meakin@lshtm.ac.uk} [contributor]
  \item James Munday \email{james.munday@lshtm.ac.uk} [contributor]
  \item Nikos Bosse [contributor]
  \item Paul Mee \email{paul.mee@lshtm.ac.uk} [contributor]
  \item Peter Ellis \email{peter.ellis2013nz@gmail.com} [contributor]
  \item Pietro Monticone \email{pietro.monticone@edu.unito.it} [contributor]
  \item Lloyd Chapman \email{lloyd.chapman1@lshtm.ac.uk} [contributor]
  \item Andrew Johnson \email{andrew.johnson@arjohnsonau.com} [contributor]
  \item Kaitlyn Johnson \email{johnsonkaitlyne9@gmail.com} (\href{https://orcid.org/0000-0001-8011-0012}{ORCID}) [contributor]
  \item Adam Howes \email{adamthowes@gmail.com} (\href{https://orcid.org/0000-0003-2386-4031}{ORCID}) [contributor]
}

}
\keyword{internal}
