% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sir_data}
\alias{sir_data}
\title{SIR Model Simulation Data}
\format{
A data frame with 50 rows and 4 columns:
\describe{
  \item{time}{Numeric, time point (1 to 50 days).}
  \item{Susceptible}{Numeric, number of susceptible individuals.}
  \item{Infected}{Numeric, number of infected individuals.}
  \item{Recovered}{Numeric, number of recovered individuals.}
}
}
\source{
Generated using \code{epi_analyze(type = "sir", N = 1000, beta = 0.3, gamma = 0.1, days = 50)}.
}
\usage{
sir_data
}
\description{
A dataset containing simulated SIR model outputs for a population of 1000.
}
\examples{
data("sir_data")
epi_visualize(sir_data, x = "time", y = "Infected", type = "curve")
}
\keyword{datasets}
