/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.likelihood;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.ohdsi.data.SortedCoxData;

public class ExposureMisclassifiedLogisticLikelihood
extends AbstractModelLikelihood {
    private final Parameter beta;
    private final Parameter nuisance;
    private final SortedCoxData data;
    private final double[] oddsLabeledExposedByStratum;
    private final int[] countByStratum;
    private static final boolean CLAMP = false;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private double logLikelihood;
    private double storedLogLikelihood;

    public ExposureMisclassifiedLogisticLikelihood(Parameter beta, Parameter nuisance, SortedCoxData data) {
        super("misclassifiedLogisticLikelihood");
        this.beta = beta;
        this.nuisance = nuisance;
        if (nuisance.getDimension() != 1) {
            throw new IllegalArgumentException("Illegal dimension for nuisance parameters");
        }
        this.data = data;
        this.addVariable((Variable)beta);
        this.addVariable((Variable)nuisance);
        ExposureMisclassifiedLogisticLikelihood.checkStrata(data.strata, data.y.length);
        this.oddsLabeledExposedByStratum = ExposureMisclassifiedLogisticLikelihood.computeOddsLabeledExposed(data.x, data.strata);
        this.countByStratum = ExposureMisclassifiedLogisticLikelihood.computeCount(data.y, data.strata);
    }

    private double calculateLogLikelihood() {
        int[] strata = this.data.strata;
        int[] y = this.data.y;
        double[] x = this.data.x;
        double[] weight = this.data.weight;
        double oddsRatio = Math.exp(this.beta.getParameterValue(0));
        double sensitivity = this.nuisance.getParameterValue(0);
        double reciprocalOddsSensitivity = (1.0 - sensitivity) / sensitivity;
        double logLikelihood = 0.0;
        int last = 0;
        int k = 0;
        while (k < strata.length) {
            double stratumEffect = reciprocalOddsSensitivity * this.oddsLabeledExposedByStratum[k] - 1.0;
            double denominator = 0.0;
            int i = last;
            while (i < strata[k]) {
                double individualOdds = weight[i] * (oddsRatio + (1.0 - x[i]) * (oddsRatio - 1.0) * stratumEffect);
                logLikelihood += y[i] == 1 ? Math.log(individualOdds) : 0.0;
                denominator += individualOdds;
                ++i;
            }
            logLikelihood -= (double)this.countByStratum[k] * Math.log(denominator);
            last = strata[k];
            ++k;
        }
        return logLikelihood;
    }

    protected void handleModelChangedEvent(Model model, Object o, int i) {
    }

    protected void handleVariableChangedEvent(Variable variable, int i, Variable.ChangeType changeType) {
        if (variable == this.beta) {
            this.likelihoodKnown = false;
        } else if (variable == this.nuisance) {
            this.likelihoodKnown = false;
        } else {
            throw new IllegalArgumentException("Unknown variable");
        }
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    private static int[] computeCount(int[] y, int[] strata) {
        int[] counts = new int[strata.length];
        int last = 0;
        int k = 0;
        while (k < strata.length) {
            int count = 0;
            int i = last;
            while (i < strata[k]) {
                count += y[i];
                ++i;
            }
            counts[k] = count;
            last = strata[k];
            ++k;
        }
        return counts;
    }

    private static double[] computeOddsLabeledExposed(double[] x, int[] strata) {
        double[] odds = new double[strata.length];
        int last = 0;
        int k = 0;
        while (k < strata.length) {
            double sum = 0.0;
            int i = last;
            while (i < strata[k]) {
                sum += x[i];
                ++i;
            }
            double proportion = sum / (double)(strata[k] - last);
            odds[k] = proportion / (1.0 - proportion);
            last = strata[k];
            ++k;
        }
        return odds;
    }

    private static void checkStrata(int[] strata, int N) {
        boolean valid = true;
        int k = 1;
        while (k < strata.length) {
            if (strata[k] <= strata[k - 1]) {
                valid = false;
                break;
            }
            ++k;
        }
        if (strata[strata.length - 1] != N) {
            valid = false;
        }
        if (!valid) {
            throw new IllegalArgumentException("Invalid strata");
        }
    }

    /*
     * Opcode count of 18406 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static SortedCoxData exampleData() {
        int[] nArray = new int[2000];
        nArray[3] = 1;
        nArray[34] = 1;
        nArray[47] = 1;
        nArray[55] = 1;
        nArray[64] = 1;
        nArray[70] = 1;
        nArray[71] = 1;
        nArray[74] = 1;
        nArray[81] = 1;
        nArray[87] = 1;
        nArray[100] = 1;
        nArray[106] = 1;
        nArray[109] = 1;
        nArray[113] = 1;
        nArray[152] = 1;
        nArray[157] = 1;
        nArray[158] = 1;
        nArray[165] = 1;
        nArray[166] = 1;
        nArray[179] = 1;
        nArray[187] = 1;
        nArray[191] = 1;
        nArray[199] = 1;
        nArray[200] = 1;
        nArray[205] = 1;
        nArray[209] = 1;
        nArray[212] = 1;
        nArray[213] = 1;
        nArray[218] = 1;
        nArray[224] = 1;
        nArray[225] = 1;
        nArray[228] = 1;
        nArray[231] = 1;
        nArray[237] = 1;
        nArray[238] = 1;
        nArray[243] = 1;
        nArray[251] = 1;
        nArray[259] = 1;
        nArray[260] = 1;
        nArray[267] = 1;
        nArray[278] = 1;
        nArray[304] = 1;
        nArray[305] = 1;
        nArray[308] = 1;
        nArray[311] = 1;
        nArray[312] = 1;
        nArray[313] = 1;
        nArray[316] = 1;
        nArray[323] = 1;
        nArray[324] = 1;
        nArray[334] = 1;
        nArray[337] = 1;
        nArray[341] = 1;
        nArray[343] = 1;
        nArray[353] = 1;
        nArray[360] = 1;
        nArray[366] = 1;
        nArray[379] = 1;
        nArray[390] = 1;
        nArray[393] = 1;
        nArray[400] = 1;
        nArray[403] = 1;
        nArray[404] = 1;
        nArray[407] = 1;
        nArray[409] = 1;
        nArray[419] = 1;
        nArray[420] = 1;
        nArray[422] = 1;
        nArray[423] = 1;
        nArray[427] = 1;
        nArray[433] = 1;
        nArray[439] = 1;
        nArray[450] = 1;
        nArray[458] = 1;
        nArray[461] = 1;
        nArray[464] = 1;
        nArray[469] = 1;
        nArray[470] = 1;
        nArray[475] = 1;
        nArray[477] = 1;
        nArray[483] = 1;
        nArray[486] = 1;
        nArray[487] = 1;
        nArray[494] = 1;
        nArray[495] = 1;
        nArray[498] = 1;
        nArray[503] = 1;
        nArray[512] = 1;
        nArray[514] = 1;
        nArray[518] = 1;
        nArray[526] = 1;
        nArray[527] = 1;
        nArray[532] = 1;
        nArray[534] = 1;
        nArray[538] = 1;
        nArray[543] = 1;
        nArray[544] = 1;
        nArray[555] = 1;
        nArray[557] = 1;
        nArray[562] = 1;
        nArray[564] = 1;
        nArray[565] = 1;
        nArray[568] = 1;
        nArray[576] = 1;
        nArray[583] = 1;
        nArray[586] = 1;
        nArray[599] = 1;
        nArray[607] = 1;
        nArray[608] = 1;
        nArray[609] = 1;
        nArray[612] = 1;
        nArray[613] = 1;
        nArray[616] = 1;
        nArray[620] = 1;
        nArray[621] = 1;
        nArray[622] = 1;
        nArray[624] = 1;
        nArray[627] = 1;
        nArray[630] = 1;
        nArray[635] = 1;
        nArray[639] = 1;
        nArray[644] = 1;
        nArray[647] = 1;
        nArray[651] = 1;
        nArray[654] = 1;
        nArray[656] = 1;
        nArray[659] = 1;
        nArray[664] = 1;
        nArray[667] = 1;
        nArray[674] = 1;
        nArray[685] = 1;
        nArray[689] = 1;
        nArray[692] = 1;
        nArray[701] = 1;
        nArray[702] = 1;
        nArray[703] = 1;
        nArray[708] = 1;
        nArray[711] = 1;
        nArray[713] = 1;
        nArray[714] = 1;
        nArray[732] = 1;
        nArray[735] = 1;
        nArray[737] = 1;
        nArray[738] = 1;
        nArray[739] = 1;
        nArray[740] = 1;
        nArray[744] = 1;
        nArray[745] = 1;
        nArray[749] = 1;
        nArray[753] = 1;
        nArray[755] = 1;
        nArray[756] = 1;
        nArray[759] = 1;
        nArray[763] = 1;
        nArray[770] = 1;
        nArray[772] = 1;
        nArray[777] = 1;
        nArray[778] = 1;
        nArray[781] = 1;
        nArray[782] = 1;
        nArray[784] = 1;
        nArray[785] = 1;
        nArray[791] = 1;
        nArray[792] = 1;
        nArray[795] = 1;
        nArray[799] = 1;
        nArray[801] = 1;
        nArray[807] = 1;
        nArray[808] = 1;
        nArray[810] = 1;
        nArray[811] = 1;
        nArray[813] = 1;
        nArray[819] = 1;
        nArray[821] = 1;
        nArray[822] = 1;
        nArray[829] = 1;
        nArray[830] = 1;
        nArray[831] = 1;
        nArray[832] = 1;
        nArray[834] = 1;
        nArray[836] = 1;
        nArray[837] = 1;
        nArray[842] = 1;
        nArray[848] = 1;
        nArray[849] = 1;
        nArray[852] = 1;
        nArray[855] = 1;
        nArray[856] = 1;
        nArray[862] = 1;
        nArray[863] = 1;
        nArray[869] = 1;
        nArray[871] = 1;
        nArray[874] = 1;
        nArray[876] = 1;
        nArray[880] = 1;
        nArray[884] = 1;
        nArray[886] = 1;
        nArray[887] = 1;
        nArray[891] = 1;
        nArray[895] = 1;
        nArray[896] = 1;
        nArray[898] = 1;
        nArray[903] = 1;
        nArray[910] = 1;
        nArray[911] = 1;
        nArray[913] = 1;
        nArray[919] = 1;
        nArray[921] = 1;
        nArray[922] = 1;
        nArray[924] = 1;
        nArray[926] = 1;
        nArray[932] = 1;
        nArray[933] = 1;
        nArray[950] = 1;
        nArray[954] = 1;
        nArray[960] = 1;
        nArray[963] = 1;
        nArray[964] = 1;
        nArray[974] = 1;
        nArray[975] = 1;
        nArray[977] = 1;
        nArray[978] = 1;
        nArray[982] = 1;
        nArray[983] = 1;
        nArray[984] = 1;
        nArray[988] = 1;
        nArray[990] = 1;
        nArray[993] = 1;
        nArray[999] = 1;
        nArray[1000] = 1;
        nArray[1006] = 1;
        nArray[1008] = 1;
        nArray[1009] = 1;
        nArray[1010] = 1;
        nArray[1017] = 1;
        nArray[1019] = 1;
        nArray[1020] = 1;
        nArray[1021] = 1;
        nArray[1023] = 1;
        nArray[1024] = 1;
        nArray[1026] = 1;
        nArray[1039] = 1;
        nArray[1042] = 1;
        nArray[1046] = 1;
        nArray[1049] = 1;
        nArray[1050] = 1;
        nArray[1051] = 1;
        nArray[1054] = 1;
        nArray[1055] = 1;
        nArray[1061] = 1;
        nArray[1064] = 1;
        nArray[1068] = 1;
        nArray[1070] = 1;
        nArray[1073] = 1;
        nArray[1075] = 1;
        nArray[1076] = 1;
        nArray[1077] = 1;
        nArray[1083] = 1;
        nArray[1086] = 1;
        nArray[1087] = 1;
        nArray[1090] = 1;
        nArray[1092] = 1;
        nArray[1093] = 1;
        nArray[1097] = 1;
        nArray[1098] = 1;
        nArray[1102] = 1;
        nArray[1108] = 1;
        nArray[1110] = 1;
        nArray[1111] = 1;
        nArray[1114] = 1;
        nArray[1116] = 1;
        nArray[1119] = 1;
        nArray[1121] = 1;
        nArray[1125] = 1;
        nArray[1138] = 1;
        nArray[1139] = 1;
        nArray[1142] = 1;
        nArray[1144] = 1;
        nArray[1147] = 1;
        nArray[1149] = 1;
        nArray[1153] = 1;
        nArray[1154] = 1;
        nArray[1156] = 1;
        nArray[1159] = 1;
        nArray[1163] = 1;
        nArray[1164] = 1;
        nArray[1167] = 1;
        nArray[1168] = 1;
        nArray[1169] = 1;
        nArray[1180] = 1;
        nArray[1184] = 1;
        nArray[1185] = 1;
        nArray[1188] = 1;
        nArray[1192] = 1;
        nArray[1196] = 1;
        nArray[1199] = 1;
        nArray[1202] = 1;
        nArray[1205] = 1;
        nArray[1207] = 1;
        nArray[1211] = 1;
        nArray[1212] = 1;
        nArray[1214] = 1;
        nArray[1216] = 1;
        nArray[1217] = 1;
        nArray[1219] = 1;
        nArray[1220] = 1;
        nArray[1225] = 1;
        nArray[1229] = 1;
        nArray[1231] = 1;
        nArray[1237] = 1;
        nArray[1243] = 1;
        nArray[1248] = 1;
        nArray[1249] = 1;
        nArray[1251] = 1;
        nArray[1253] = 1;
        nArray[1259] = 1;
        nArray[1261] = 1;
        nArray[1262] = 1;
        nArray[1264] = 1;
        nArray[1267] = 1;
        nArray[1271] = 1;
        nArray[1272] = 1;
        nArray[1273] = 1;
        nArray[1276] = 1;
        nArray[1280] = 1;
        nArray[1283] = 1;
        nArray[1293] = 1;
        nArray[1294] = 1;
        nArray[1295] = 1;
        nArray[1297] = 1;
        nArray[1299] = 1;
        nArray[1300] = 1;
        nArray[1301] = 1;
        nArray[1315] = 1;
        nArray[1316] = 1;
        nArray[1318] = 1;
        nArray[1320] = 1;
        nArray[1323] = 1;
        nArray[1324] = 1;
        nArray[1329] = 1;
        nArray[1332] = 1;
        nArray[1333] = 1;
        nArray[1335] = 1;
        nArray[1337] = 1;
        nArray[1338] = 1;
        nArray[1340] = 1;
        nArray[1355] = 1;
        nArray[1359] = 1;
        nArray[1360] = 1;
        nArray[1363] = 1;
        nArray[1364] = 1;
        nArray[1366] = 1;
        nArray[1367] = 1;
        nArray[1370] = 1;
        nArray[1371] = 1;
        nArray[1372] = 1;
        nArray[1373] = 1;
        nArray[1380] = 1;
        nArray[1383] = 1;
        nArray[1387] = 1;
        nArray[1390] = 1;
        nArray[1392] = 1;
        nArray[1393] = 1;
        nArray[1399] = 1;
        nArray[1402] = 1;
        nArray[1404] = 1;
        nArray[1409] = 1;
        nArray[1411] = 1;
        nArray[1412] = 1;
        nArray[1414] = 1;
        nArray[1415] = 1;
        nArray[1419] = 1;
        nArray[1420] = 1;
        nArray[1421] = 1;
        nArray[1423] = 1;
        nArray[1424] = 1;
        nArray[1427] = 1;
        nArray[1428] = 1;
        nArray[1429] = 1;
        nArray[1430] = 1;
        nArray[1432] = 1;
        nArray[1436] = 1;
        nArray[1446] = 1;
        nArray[1453] = 1;
        nArray[1455] = 1;
        nArray[1456] = 1;
        nArray[1457] = 1;
        nArray[1460] = 1;
        nArray[1461] = 1;
        nArray[1462] = 1;
        nArray[1469] = 1;
        nArray[1470] = 1;
        nArray[1472] = 1;
        nArray[1476] = 1;
        nArray[1478] = 1;
        nArray[1480] = 1;
        nArray[1481] = 1;
        nArray[1487] = 1;
        nArray[1490] = 1;
        nArray[1492] = 1;
        nArray[1493] = 1;
        nArray[1495] = 1;
        nArray[1498] = 1;
        nArray[1502] = 1;
        nArray[1505] = 1;
        nArray[1506] = 1;
        nArray[1510] = 1;
        nArray[1514] = 1;
        nArray[1515] = 1;
        nArray[1516] = 1;
        nArray[1518] = 1;
        nArray[1522] = 1;
        nArray[1523] = 1;
        nArray[1526] = 1;
        nArray[1527] = 1;
        nArray[1530] = 1;
        nArray[1535] = 1;
        nArray[1545] = 1;
        nArray[1547] = 1;
        nArray[1549] = 1;
        nArray[1550] = 1;
        nArray[1553] = 1;
        nArray[1555] = 1;
        nArray[1556] = 1;
        nArray[1562] = 1;
        nArray[1563] = 1;
        nArray[1565] = 1;
        nArray[1567] = 1;
        nArray[1569] = 1;
        nArray[1573] = 1;
        nArray[1574] = 1;
        nArray[1577] = 1;
        nArray[1578] = 1;
        nArray[1581] = 1;
        nArray[1582] = 1;
        nArray[1585] = 1;
        nArray[1588] = 1;
        nArray[1590] = 1;
        nArray[1595] = 1;
        nArray[1602] = 1;
        nArray[1603] = 1;
        nArray[1604] = 1;
        nArray[1606] = 1;
        nArray[1610] = 1;
        nArray[1612] = 1;
        nArray[1614] = 1;
        nArray[1615] = 1;
        nArray[1616] = 1;
        nArray[1617] = 1;
        nArray[1619] = 1;
        nArray[1620] = 1;
        nArray[1621] = 1;
        nArray[1624] = 1;
        nArray[1629] = 1;
        nArray[1631] = 1;
        nArray[1636] = 1;
        nArray[1641] = 1;
        nArray[1643] = 1;
        nArray[1645] = 1;
        nArray[1646] = 1;
        nArray[1651] = 1;
        nArray[1655] = 1;
        nArray[1657] = 1;
        nArray[1659] = 1;
        nArray[1660] = 1;
        nArray[1662] = 1;
        nArray[1664] = 1;
        nArray[1665] = 1;
        nArray[1666] = 1;
        nArray[1667] = 1;
        nArray[1668] = 1;
        nArray[1670] = 1;
        nArray[1672] = 1;
        nArray[1675] = 1;
        nArray[1677] = 1;
        nArray[1679] = 1;
        nArray[1682] = 1;
        nArray[1687] = 1;
        nArray[1688] = 1;
        nArray[1689] = 1;
        nArray[1691] = 1;
        nArray[1694] = 1;
        nArray[1696] = 1;
        nArray[1697] = 1;
        nArray[1702] = 1;
        nArray[1705] = 1;
        nArray[1708] = 1;
        nArray[1712] = 1;
        nArray[1719] = 1;
        nArray[1723] = 1;
        nArray[1724] = 1;
        nArray[1726] = 1;
        nArray[1727] = 1;
        nArray[1729] = 1;
        nArray[1734] = 1;
        nArray[1736] = 1;
        nArray[1737] = 1;
        nArray[1743] = 1;
        nArray[1749] = 1;
        nArray[1750] = 1;
        nArray[1755] = 1;
        nArray[1757] = 1;
        nArray[1763] = 1;
        nArray[1765] = 1;
        nArray[1766] = 1;
        nArray[1767] = 1;
        nArray[1770] = 1;
        nArray[1778] = 1;
        nArray[1780] = 1;
        nArray[1784] = 1;
        nArray[1787] = 1;
        nArray[1788] = 1;
        nArray[1794] = 1;
        nArray[1801] = 1;
        nArray[1803] = 1;
        nArray[1804] = 1;
        nArray[1805] = 1;
        nArray[1806] = 1;
        nArray[1808] = 1;
        nArray[1812] = 1;
        nArray[1813] = 1;
        nArray[1814] = 1;
        nArray[1815] = 1;
        nArray[1822] = 1;
        nArray[1823] = 1;
        nArray[1826] = 1;
        nArray[1828] = 1;
        nArray[1829] = 1;
        nArray[1836] = 1;
        nArray[1837] = 1;
        nArray[1839] = 1;
        nArray[1842] = 1;
        nArray[1844] = 1;
        nArray[1849] = 1;
        nArray[1854] = 1;
        nArray[1856] = 1;
        nArray[1858] = 1;
        nArray[1860] = 1;
        nArray[1861] = 1;
        nArray[1863] = 1;
        nArray[1873] = 1;
        nArray[1874] = 1;
        nArray[1877] = 1;
        nArray[1878] = 1;
        nArray[1879] = 1;
        nArray[1882] = 1;
        nArray[1884] = 1;
        nArray[1892] = 1;
        nArray[1895] = 1;
        nArray[1897] = 1;
        nArray[1902] = 1;
        nArray[1904] = 1;
        nArray[1905] = 1;
        nArray[1907] = 1;
        nArray[1908] = 1;
        nArray[1909] = 1;
        nArray[1910] = 1;
        nArray[1918] = 1;
        nArray[1921] = 1;
        nArray[1923] = 1;
        nArray[1924] = 1;
        nArray[1928] = 1;
        nArray[1931] = 1;
        nArray[1934] = 1;
        nArray[1946] = 1;
        nArray[1948] = 1;
        nArray[1950] = 1;
        nArray[1951] = 1;
        nArray[1954] = 1;
        nArray[1960] = 1;
        nArray[1962] = 1;
        nArray[1963] = 1;
        nArray[1964] = 1;
        nArray[1966] = 1;
        nArray[1967] = 1;
        nArray[1968] = 1;
        nArray[1969] = 1;
        nArray[1970] = 1;
        nArray[1971] = 1;
        nArray[1979] = 1;
        nArray[1981] = 1;
        nArray[1983] = 1;
        nArray[1985] = 1;
        nArray[1986] = 1;
        nArray[1988] = 1;
        nArray[1990] = 1;
        nArray[1992] = 1;
        nArray[1994] = 1;
        nArray[1996] = 1;
        nArray[1998] = 1;
        nArray[1999] = 1;
        int[] y = nArray;
        double[] x = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
        double[] weight = new double[]{1.6, 1.0, 0.9, 1.8, 1.1, 0.5, 0.7, 0.3, 1.6, 1.6, 0.4, 1.5, 1.6, 1.0, 1.2, 1.0, 0.5, 0.8, 1.4, 1.0, 0.3, 1.2, 1.7, 1.6, 0.4, 1.0, 0.2, 1.6, 0.9, 0.9, 0.3, 1.3, 1.8, 0.5, 1.7, 0.8, 0.9, 1.8, 0.4, 1.5, 1.4, 0.3, 1.8, 1.0, 1.0, 1.5, 0.6, 1.0, 0.9, 0.6, 0.4, 0.3, 0.4, 1.4, 1.2, 1.7, 0.5, 0.8, 0.5, 1.9, 1.8, 1.0, 1.7, 0.5, 1.4, 0.7, 0.9, 1.6, 1.6, 1.7, 0.7, 1.9, 1.3, 0.9, 1.5, 1.1, 1.0, 2.0, 1.0, 1.2, 0.3, 1.7, 1.4, 0.7, 0.9, 0.7, 1.1, 0.4, 1.1, 0.5, 1.1, 0.4, 1.3, 1.6, 1.7, 0.7, 1.3, 1.1, 1.4, 1.8, 0.9, 0.4, 0.5, 0.3, 0.4, 1.4, 1.1, 1.5, 1.7, 1.4, 0.8, 1.5, 1.2, 1.8, 1.6, 1.0, 1.6, 1.0, 0.6, 0.3, 1.7, 1.0, 1.0, 0.9, 1.5, 1.2, 1.5, 1.1, 0.8, 0.7, 0.6, 0.2, 1.1, 0.9, 0.7, 1.9, 1.3, 0.6, 0.6, 0.3, 0.9, 1.0, 0.8, 0.6, 1.2, 1.1, 0.8, 0.6, 1.7, 1.6, 0.8, 1.9, 1.5, 0.8, 0.6, 0.5, 0.8, 1.3, 1.8, 1.6, 1.9, 0.3, 0.4, 1.4, 1.2, 2.0, 1.1, 1.6, 1.3, 0.8, 0.4, 0.2, 0.6, 1.4, 0.7, 0.4, 1.0, 1.5, 0.7, 0.5, 0.5, 1.1, 0.3, 0.7, 0.9, 1.3, 1.8, 1.7, 1.7, 1.3, 1.7, 1.2, 1.9, 1.7, 1.6, 1.8, 1.7, 1.0, 1.2, 1.6, 0.4, 0.7, 1.2, 0.4, 1.3, 1.4, 1.1, 0.9, 1.0, 1.7, 1.3, 1.3, 1.6, 0.8, 1.3, 0.7, 1.7, 1.8, 1.8, 1.4, 0.3, 1.9, 1.7, 0.6, 1.7, 0.7, 1.9, 0.3, 1.9, 0.6, 1.9, 1.7, 1.2, 0.6, 1.5, 0.5, 1.4, 1.8, 0.6, 0.9, 2.0, 1.6, 0.3, 1.6, 1.7, 1.2, 1.5, 0.7, 1.9, 0.8, 1.6, 1.2, 0.6, 0.9, 1.0, 1.2, 1.9, 1.6, 1.8, 1.3, 1.8, 0.9, 1.1, 1.5, 0.7, 1.8, 1.1, 2.0, 0.6, 1.0, 1.8, 1.7, 0.3, 0.8, 1.6, 1.2, 1.6, 0.7, 1.3, 0.4, 0.9, 1.7, 0.5, 1.9, 0.2, 0.2, 0.4, 0.4, 0.9, 1.3, 0.9, 0.3, 1.2, 0.7, 0.9, 1.1, 1.8, 1.3, 1.1, 1.1, 2.0, 0.9, 1.4, 0.9, 1.4, 2.0, 0.8, 0.5, 0.9, 0.6, 1.1, 1.3, 1.8, 1.4, 1.9, 1.6, 1.4, 0.8, 1.0, 0.5, 1.1, 0.3, 1.2, 1.1, 1.3, 0.5, 0.4, 0.4, 0.6, 1.5, 0.4, 1.7, 1.7, 0.7, 1.1, 1.9, 1.0, 1.7, 1.2, 1.1, 1.0, 0.6, 1.7, 1.0, 1.3, 0.7, 1.7, 0.9, 0.3, 1.2, 1.8, 0.6, 1.1, 1.4, 1.1, 0.3, 0.3, 0.3, 1.2, 1.7, 1.3, 0.6, 1.0, 0.2, 1.2, 0.7, 1.2, 0.5, 0.9, 0.2, 1.2, 0.4, 1.6, 1.2, 0.3, 0.2, 0.5, 1.3, 0.4, 1.3, 0.8, 1.4, 1.8, 0.7, 1.0, 1.4, 1.5, 1.6, 0.5, 1.4, 0.9, 1.1, 0.3, 1.6, 1.7, 1.7, 0.8, 1.6, 0.6, 0.4, 1.6, 1.0, 0.3, 1.8, 0.6, 0.3, 1.6, 1.6, 1.5, 2.0, 1.1, 1.3, 1.5, 1.4, 1.8, 0.5, 1.1, 1.3, 1.7, 1.5, 1.8, 0.7, 1.9, 0.9, 0.5, 0.6, 0.5, 1.5, 1.0, 0.2, 1.2, 0.9, 0.3, 0.9, 0.6, 0.9, 0.3, 0.4, 1.8, 1.7, 0.3, 1.9, 1.9, 0.9, 0.5, 0.5, 1.7, 0.3, 1.1, 1.3, 1.3, 1.1, 1.4, 1.5, 1.1, 0.8, 0.8, 1.0, 1.6, 0.9, 1.7, 1.2, 0.2, 1.7, 0.5, 0.6, 0.8, 1.7, 1.1, 1.5, 0.9, 0.8, 1.6, 0.6, 0.6, 1.7, 0.8, 1.5, 0.3, 0.5, 1.7, 0.8, 1.4, 1.7, 1.8, 1.0, 1.4, 1.2, 0.9, 0.4, 1.2, 1.9, 0.5, 1.3, 1.1, 1.4, 1.8, 1.7, 2.0, 1.8, 1.0, 0.4, 0.9, 1.7, 1.7, 0.8, 1.3, 1.6, 1.6, 0.9, 0.4, 0.5, 1.9, 0.2, 1.8, 1.9, 1.3, 1.1, 0.7, 1.0, 0.7, 1.6, 1.3, 1.5, 1.2, 0.4, 0.7, 1.6, 1.0, 0.9, 1.6, 0.9, 0.3, 1.9, 0.6, 0.6, 1.1, 0.4, 1.2, 1.2, 1.5, 1.6, 1.6, 0.5, 1.0, 0.7, 1.4, 1.5, 0.3, 0.7, 0.3, 1.2, 0.4, 1.9, 1.8, 1.7, 1.7, 1.0, 0.9, 1.8, 0.9, 1.5, 1.2, 1.2, 0.7, 0.5, 1.6, 1.1, 1.3, 1.1, 0.5, 0.9, 1.9, 1.2, 0.6, 0.4, 1.0, 1.9, 1.9, 1.4, 1.6, 1.8, 1.8, 0.8, 0.6, 1.1, 0.7, 1.6, 0.4, 1.1, 0.7, 2.0, 1.1, 0.5, 1.1, 1.2, 0.7, 0.7, 0.4, 1.3, 0.7, 1.3, 0.4, 0.7, 1.7, 0.9, 1.0, 0.3, 1.1, 1.1, 1.4, 1.1, 1.8, 1.7, 1.3, 0.5, 1.3, 1.1, 0.8, 1.8, 1.4, 1.1, 0.5, 1.8, 1.0, 1.6, 0.9, 1.9, 1.5, 0.9, 1.8, 1.3, 1.1, 1.3, 0.4, 0.3, 0.8, 0.9, 1.7, 0.5, 0.3, 1.1, 1.5, 1.4, 1.7, 0.4, 0.3, 1.5, 0.5, 0.7, 1.2, 2.0, 0.8, 1.6, 1.3, 1.2, 0.7, 0.3, 1.1, 0.7, 1.5, 1.3, 1.2, 1.2, 1.7, 1.0, 0.2, 1.5, 0.9, 1.3, 1.9, 0.9, 1.0, 1.7, 1.5, 0.4, 0.3, 1.3, 1.4, 1.8, 2.0, 1.4, 1.2, 1.8, 1.6, 1.0, 1.2, 1.5, 0.4, 0.4, 1.0, 1.2, 1.5, 1.0, 1.4, 0.9, 1.0, 0.4, 0.3, 0.2, 1.4, 1.4, 1.5, 1.8, 1.6, 0.9, 1.9, 1.6, 1.1, 1.4, 0.5, 1.4, 0.9, 0.8, 1.8, 0.4, 0.3, 0.7, 1.2, 1.3, 0.9, 2.0, 1.7, 1.3, 0.9, 0.8, 0.6, 0.4, 0.9, 1.2, 1.3, 0.5, 0.6, 0.4, 1.1, 1.1, 1.7, 0.6, 1.4, 2.0, 0.4, 0.2, 1.7, 1.2, 2.0, 1.1, 1.2, 1.0, 0.5, 1.9, 0.5, 0.3, 1.2, 1.2, 2.0, 0.3, 1.2, 1.9, 0.5, 0.8, 1.3, 0.9, 1.2, 1.0, 0.9, 1.8, 0.2, 0.2, 1.1, 0.5, 1.0, 1.8, 1.4, 0.5, 0.3, 0.6, 1.8, 1.6, 1.7, 0.4, 0.3, 0.5, 1.5, 0.7, 1.5, 0.6, 1.6, 0.5, 1.3, 1.3, 1.9, 1.5, 1.4, 1.1, 1.2, 2.0, 1.4, 2.0, 0.9, 1.9, 1.1, 0.9, 2.0, 1.6, 1.4, 0.5, 1.3, 1.6, 0.5, 1.9, 2.0, 1.2, 1.1, 1.6, 0.5, 1.8, 2.0, 0.7, 0.4, 1.7, 0.9, 1.8, 0.4, 1.1, 1.7, 0.5, 1.5, 2.0, 1.0, 1.7, 0.7, 1.2, 1.6, 0.4, 0.6, 0.4, 1.3, 1.9, 1.4, 1.0, 1.1, 1.0, 1.9, 1.3, 0.7, 0.6, 1.0, 1.0, 1.0, 1.5, 1.6, 0.9, 1.9, 1.1, 0.4, 0.4, 1.1, 1.9, 1.0, 0.2, 1.2, 0.5, 1.0, 1.8, 1.4, 1.0, 1.8, 0.5, 1.5, 1.9, 0.6, 0.8, 0.2, 0.9, 0.8, 0.3, 1.0, 0.3, 0.4, 1.4, 1.4, 1.0, 1.1, 0.9, 1.0, 0.7, 0.6, 1.6, 1.5, 1.0, 0.4, 0.8, 0.8, 1.0, 1.2, 1.1, 0.5, 1.6, 1.1, 1.8, 2.0, 1.5, 0.3, 1.0, 1.4, 1.2, 1.4, 0.9, 1.0, 1.6, 1.0, 1.5, 0.5, 1.1, 1.2, 1.4, 1.0, 1.8, 0.7, 1.9, 1.8, 0.4, 0.3, 0.7, 0.7, 0.4, 0.7, 1.4, 0.2, 1.5, 0.5, 1.4, 1.7, 1.7, 0.8, 0.3, 0.6, 0.8, 0.6, 0.5, 0.8, 1.1, 0.7, 1.9, 0.8, 0.4, 0.4, 0.7, 0.4, 0.7, 0.5, 0.6, 1.2, 1.1, 0.7, 0.3, 0.6, 1.0, 0.6, 1.9, 0.5, 0.5, 0.8, 0.7, 1.9, 0.7, 1.2, 0.3, 1.4, 0.2, 1.0, 0.9, 1.5, 1.7, 1.8, 0.7, 1.7, 1.6, 2.0, 1.1, 0.5, 0.5, 1.2, 0.4, 1.8, 0.3, 0.5, 0.2, 1.2, 0.6, 1.9, 0.6, 0.6, 1.8, 0.5, 0.3, 0.3, 1.0, 0.8, 1.1, 1.4, 1.8, 0.2, 1.7, 1.9, 0.6, 0.3, 0.4, 1.6, 1.6, 1.6, 0.9, 0.3, 1.7, 0.2, 0.5, 0.3, 1.7, 1.8, 0.6, 1.6, 1.1, 1.1, 0.9, 1.3, 0.5, 1.9, 0.2, 1.5, 1.2, 1.5, 1.7, 1.5, 1.6, 2.0, 1.0, 1.2, 0.8, 0.8, 1.0, 1.1, 0.4, 0.8, 1.9, 1.6, 1.7, 1.4, 0.5, 0.8, 1.4, 1.3, 1.4, 0.2, 0.4, 0.8, 0.9, 1.5, 1.0, 1.2, 0.3, 1.1, 0.6, 0.4, 0.9, 1.6, 0.9, 0.4, 1.0, 1.6, 1.7, 1.9, 1.2, 0.3, 1.8, 0.8, 1.5, 1.0, 1.6, 0.5, 1.5, 1.6, 1.6, 1.1, 1.0, 1.1, 0.2, 0.4, 1.3, 0.4, 1.8, 0.4, 1.2, 1.7, 1.7, 0.7, 1.3, 1.9, 2.0, 0.4, 0.4, 0.3, 1.4, 1.0, 1.9, 0.5, 0.5, 0.7, 0.3, 1.1, 0.4, 0.8, 1.4, 0.9, 1.5, 1.6, 1.6, 1.2, 1.6, 1.4, 1.4, 0.8, 1.9, 1.7, 0.8, 0.8, 1.6, 1.0, 1.1, 1.4, 1.1, 0.3, 0.7, 1.8, 2.0, 1.1, 1.8, 1.2, 0.6, 1.8, 1.9, 0.9, 0.2, 1.3, 0.9, 1.1, 0.9, 0.4, 1.9, 0.6, 0.8, 1.1, 0.4, 0.8, 0.9, 0.9, 1.8, 1.6, 1.0, 0.9, 0.9, 1.8, 1.7, 0.9, 1.5, 1.2, 1.3, 0.3, 1.5, 1.4, 1.7, 0.4, 0.7, 0.3, 1.2, 1.8, 1.1, 0.3, 0.4, 0.5, 0.4, 1.9, 0.5, 0.5, 0.4, 1.8, 1.2, 0.5, 0.9, 1.9, 0.9, 1.7, 0.5, 1.4, 1.1, 1.2, 0.9, 1.7, 0.3, 1.6, 1.3, 1.4, 0.5, 0.3, 1.5, 1.6, 1.3, 1.5, 1.0, 1.7, 1.7, 0.4, 0.4, 1.7, 1.8, 0.9, 1.4, 1.9, 1.8, 1.0, 1.1, 0.8, 2.0, 1.8, 1.0, 1.9, 0.8, 0.2, 1.1, 0.8, 1.6, 1.5, 0.6, 1.5, 1.0, 0.9, 1.3, 0.8, 0.3, 1.2, 1.1, 0.7, 1.0, 1.0, 1.7, 0.5, 2.0, 1.9, 0.5, 0.5, 0.9, 0.6, 1.9, 0.3, 0.9, 0.5, 1.4, 1.3, 0.3, 0.3, 1.6, 0.6, 1.7, 1.1, 0.8, 0.7, 1.9, 0.7, 1.5, 1.4, 1.9, 1.6, 1.3, 1.5, 0.8, 1.8, 0.6, 1.7, 0.6, 1.4, 1.7, 1.8, 0.2, 0.6, 1.5, 1.6, 0.9, 1.7, 0.9, 1.7, 1.9, 0.8, 1.1, 0.4, 1.9, 1.5, 1.7, 1.4, 0.6, 1.6, 1.6, 1.7, 1.6, 0.4, 0.5, 1.8, 1.9, 0.3, 0.2, 0.6, 0.8, 1.2, 0.6, 0.2, 1.0, 1.3, 1.8, 1.6, 1.2, 1.1, 0.5, 1.9, 0.5, 1.6, 0.9, 0.5, 0.4, 1.0, 0.5, 0.3, 1.7, 0.4, 0.4, 1.7, 1.2, 2.0, 1.9, 1.8, 1.4, 2.0, 1.1, 2.0, 0.9, 0.6, 0.7, 0.6, 1.2, 0.7, 1.8, 1.9, 0.7, 0.6, 1.2, 1.4, 1.6, 1.6, 2.0, 0.3, 1.4, 1.1, 1.7, 1.9, 0.6, 1.5, 2.0, 0.7, 1.2, 1.5, 1.2, 0.5, 0.6, 1.8, 1.0, 0.4, 1.0, 1.3, 0.8, 0.4, 1.0, 1.1, 1.4, 1.1, 0.7, 1.5, 1.2, 0.4, 1.2, 1.0, 1.9, 1.1, 1.1, 2.0, 1.4, 1.7, 1.7, 1.2, 0.2, 0.9, 1.9, 1.7, 1.8, 0.6, 1.4, 1.0, 0.9, 1.4, 1.7, 0.4, 1.8, 0.8, 0.9, 0.4, 0.9, 1.7, 1.5, 0.8, 0.7, 0.4, 1.9, 0.4, 1.6, 0.7, 0.5, 1.2, 1.3, 0.7, 1.0, 1.3, 0.4, 1.6, 0.5, 0.9, 0.4, 1.9, 0.6, 0.8, 0.8, 0.7, 1.6, 1.1, 1.2, 0.7, 0.9, 1.9, 0.9, 1.9, 0.8, 1.5, 0.4, 0.2, 1.6, 0.6, 0.6, 1.0, 1.7, 1.3, 0.9, 1.0, 1.8, 1.6, 0.2, 1.0, 1.7, 0.9, 0.6, 0.6, 0.5, 0.4, 0.9, 0.9, 0.5, 0.9, 0.4, 0.9, 1.0, 1.1, 0.8, 0.8, 1.2, 0.5, 1.6, 1.7, 1.6, 0.6, 0.6, 0.6, 0.6, 0.5, 1.5, 0.9, 0.4, 1.1, 1.3, 0.6, 1.0, 1.6, 0.8, 1.2, 1.1, 0.7, 0.4, 0.7, 0.8, 1.9, 0.2, 1.6, 0.8, 2.0, 0.8, 1.8, 0.9, 1.6, 0.9, 0.4, 1.4, 0.6, 1.0, 0.7, 1.5, 1.1, 0.6, 1.8, 1.4, 1.0, 1.3, 1.2, 0.2, 1.2, 0.6, 1.6, 1.7, 1.6, 1.3, 0.7, 1.9, 0.5, 1.0, 0.3, 2.0, 2.0, 0.7, 0.3, 0.4, 1.5, 0.7, 0.2, 0.9, 0.3, 0.6, 1.0, 2.0, 0.4, 0.3, 1.2, 2.0, 2.0, 1.7, 1.0, 0.3, 1.4, 0.3, 0.8, 0.5, 1.5, 1.8, 0.6, 1.2, 0.5, 1.2, 1.0, 1.7, 1.6, 1.1, 1.4, 1.5, 0.7, 0.6, 1.0, 0.9, 1.8, 1.9, 0.4, 1.6, 1.2, 1.0, 1.4, 1.7, 1.5, 1.3, 1.0, 1.4, 1.5, 0.5, 1.2, 1.7, 1.2, 0.4, 0.4, 0.3, 1.7, 1.6, 0.3, 1.5, 1.9, 1.8, 0.2, 1.3, 1.1, 0.8, 1.8, 1.3, 0.7, 1.0, 1.5, 0.9, 1.9, 1.0, 2.0, 1.2, 1.6, 1.4, 1.7, 0.5, 0.8, 0.7, 1.3, 1.4, 2.0, 1.7, 1.3, 1.1, 0.3, 0.8, 0.3, 0.4, 1.1, 1.4, 0.4, 1.3, 0.5, 0.7, 0.4, 2.0, 1.0, 1.8, 1.5, 0.6, 1.1, 0.5, 0.6, 0.2, 0.9, 1.4, 0.6, 0.2, 0.9, 1.5, 0.4, 2.0, 0.3, 0.7, 0.8, 1.8, 1.0, 0.8, 1.6, 0.8, 0.8, 1.2, 1.0, 1.1, 1.2, 0.4, 0.4, 0.6, 0.7, 1.3, 1.6, 1.1, 0.4, 1.4, 1.2, 1.4, 1.9, 0.4, 1.6, 0.8, 1.6, 1.5, 1.6, 2.0, 1.8, 1.8, 1.5, 1.6, 1.5, 0.5, 0.9, 1.4, 0.4, 1.9, 1.2, 1.5, 1.9, 0.6, 0.8, 1.0, 1.3, 0.6, 1.9, 0.4, 0.5, 1.4, 1.3, 0.6, 1.7, 1.6, 0.3, 1.9, 0.6, 1.3, 0.6, 1.4, 0.3, 1.9, 0.6, 0.3, 1.4, 0.8, 1.9, 1.6, 1.2, 1.1, 0.3, 1.6, 1.8, 0.3, 1.7, 1.6, 1.6, 0.5, 0.5, 1.1, 0.3, 0.7, 1.5, 1.8, 0.4, 0.6, 0.8, 0.4, 2.0, 1.2, 1.0, 1.4, 1.0, 1.2, 1.0, 1.6, 0.7, 0.7, 1.5, 0.6, 1.8, 1.9, 0.4, 1.6, 1.1, 1.2, 1.1, 1.0, 0.6, 0.6, 0.3, 1.5, 0.3, 0.7, 0.5, 0.3, 1.8, 1.1, 1.8, 1.8, 1.8, 0.5, 1.6, 1.9, 0.5, 1.1, 1.6, 0.5, 0.2, 1.0, 0.8, 0.3, 0.6, 0.3, 0.4, 0.2, 0.6, 1.0, 1.2, 0.8, 0.9, 1.0, 0.7, 1.7, 1.0, 0.7, 0.6, 0.2, 1.3, 0.6, 0.7, 0.7, 1.3, 0.3, 0.3, 1.9, 0.4, 1.1, 0.5, 0.4, 0.6, 1.4, 1.1, 1.4, 2.0, 0.4, 0.4, 1.9, 0.5, 1.2, 0.3, 1.6, 0.4, 0.3, 1.1, 0.8, 0.9, 1.5, 0.6, 0.8, 0.9, 1.4, 1.6, 0.4, 0.5, 1.3, 1.9, 0.7, 1.7, 1.4, 1.5, 1.0, 1.2, 1.3, 1.7, 0.3, 0.3, 0.4, 1.8, 2.0, 2.0, 0.3, 0.6, 0.2, 0.4, 0.7, 1.0, 1.2, 0.7, 1.7, 0.9, 1.8, 1.2, 0.3, 1.1, 1.6, 1.4, 0.7, 1.1, 0.3, 0.4, 1.9, 1.0, 1.0, 1.7, 1.8, 1.7, 1.1, 1.6, 1.9, 0.8, 1.1, 1.8, 0.9, 0.3, 1.4, 0.9, 0.4, 1.4, 1.3, 1.3, 0.5, 1.2, 1.1, 1.6, 1.4, 1.0, 1.7, 1.6, 1.1, 0.5, 1.6, 0.9, 0.7, 1.5, 0.8, 1.9, 0.4, 0.7, 1.4, 1.8, 1.1, 2.0, 0.4, 0.6, 2.0, 1.9, 1.2, 0.6, 0.7, 1.0, 1.4, 1.2, 2.0, 0.4, 1.8, 1.0, 1.0, 0.7, 0.5, 0.8, 0.4, 1.6, 0.6, 1.5, 1.4, 0.5, 0.8, 0.4, 1.9, 1.9, 0.6, 1.6, 0.2, 1.8, 1.8, 1.1, 0.5, 1.1, 1.8, 1.9, 2.0, 0.9, 0.9, 1.2, 1.6, 1.4, 1.4, 1.6, 0.3, 1.9, 0.6, 0.4, 0.8, 0.3, 1.6, 1.4, 0.9, 1.4, 1.1, 0.5, 0.4, 1.8, 0.6, 1.8, 1.8, 1.2, 1.5, 0.8, 0.3, 1.8, 1.0, 1.5, 1.4, 1.3, 1.1, 0.7, 0.4};
        int[] strata = new int[]{400, 801, 1207, 1601, 2000};
        return new SortedCoxData(y, x, strata, null, weight);
    }

    public static void main(String[] args) {
        double beta = 0.1;
        double sensitivity = 0.9;
        SortedCoxData data = ExposureMisclassifiedLogisticLikelihood.exampleData();
        Parameter.Default parameter = new Parameter.Default(new double[]{beta});
        Parameter.Default nuisance = new Parameter.Default(new double[]{sensitivity});
        ExposureMisclassifiedLogisticLikelihood cox = new ExposureMisclassifiedLogisticLikelihood((Parameter)parameter, (Parameter)nuisance, data);
        System.err.println(cox.getLogLikelihood());
    }
}

