% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error.R
\name{error.krr}
\alias{error.krr}
\title{Compute Model Error for Kernel Ridge Regression Models}
\usage{
\method{error}{krr}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"krr"}, typically returned by
\code{\link{fastkrr}}.}

\item{...}{Additional arguments (ignored).}
}
\value{
A numeric value giving the mean squared error (MSE).
}
\description{
Computes the model error for kernel ridge regression (\code{"krr"}) objects.
Returns the mean squared error (MSE) between the observed responses
and the fitted values stored in the object.
}
\details{
This method computes:
\deqn{\text{MSE} = \frac{1}{n} \sum_i (y_i - \hat{y}_i)^2}
where \code{y} and \code{fitted.values} are stored in the \code{"krr"} object attributes.
}
\examples{
# Data setting
set.seed(1)
lambda = 1e-4
d = 1
n = 50
rho = 1
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))

model = fastkrr(X, y, kernel = "gaussian", lambda = 0.001)
error(model)


}
\seealso{
\code{\link{summary.krr}}, \code{\link{plot.krr}}, \code{\link{predict.krr}}
}
