#ifndef GBOP2_TYPES_H
#define GBOP2_TYPES_H

#define R_NO_REMAP
#define ARMA_DONT_USE_WRAPPER
#include <vector>
#include <RcppArmadillo.h>

/**
 * Data struct using standard C++ types to avoid 
 * non-API attribute calls during internal calculations.
 */
struct Data {
  std::vector<int> num_event;
  std::vector<double> prob;
};

/**
 * Result_singleE updated to use standard vectors for 
 * consistency and to avoid R-devel 'ATTRIB' notes.
 */
struct Result_singleE {
  Data nonstopping_df_null;
  Data nonstopping_df_alter;
  double nonstop_prob_null;
  double nonstop_prob_alter;
  double expected_size;
};

/**
 * Result_dualE updated. Note that prob_size members 
 * now use std::vector instead of Rcpp::NumericVector.
 */
struct Result_dualE {
  Data effective_df;
  double effective_prob;
  double cummu_effective;
  Data nonstop_df;
  double expected_size;
  double stopping_prob;
  double nonstopping_prob;
  
  // Use std::vector for internal storage
  std::vector<double> prob_size_futile;
  std::vector<double> prob_size_effective;
  std::vector<double> prob_size_nonstop;
};

#endif
