% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_list_workflows}
\alias{galaxy_list_workflows}
\title{List workflows available to the user}
\usage{
galaxy_list_workflows(
  include_public = FALSE,
  galaxy_url = "https://usegalaxy.eu"
)
}
\arguments{
\item{include_public}{Logical. If \code{TRUE}, attempt to also include
published public workflows. Default: \code{FALSE}.}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}
}
\value{
A data.frame with one row per workflow and columns including:
\code{id}, \code{name}, \code{published}, \code{owner}.
}
\description{
Retrieves workflows accessible to the authenticated user from a Galaxy
instance. Optionally includes public (published) workflows if supported
by the Galaxy server.
}
\details{
By default, only workflows owned by or shared with the current user
are returned. When \code{include_public = TRUE}, the function will
attempt to request published workflows as well. Availability of
public workflows depends on the Galaxy instance and version.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
workflows <- galaxy_list_workflows(TRUE)
head(workflows)
\dontshow{\}) # examplesIf}
}
