% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylotree_class.R
\name{create_phylotree}
\alias{create_phylotree}
\title{Create a \code{Phylotree} object}
\usage{
create_phylotree(B, clones, genes, parents, tree, labels = NA)
}
\arguments{
\item{B}{A square matrix that represents the phylogenetic tree.}

\item{clones}{A numeric vector representing the clones in the phylogenetic tree.}

\item{genes}{A numeric vector representing the genes in the phylogenetic tree.}

\item{parents}{A numeric vector representing the parents of the clones in the phylogenetic tree.}

\item{tree}{A \code{data.tree} object containing the tree structure of the phylogenetic tree.}

\item{labels}{An optional vector containing the tags of the genes in the phylogenetic tree. \code{NA} by default.}
}
\value{
A \code{Phylotree} class object.
}
\description{
This is the general constructor of the \code{Phylotree} S4 class.
}
\examples{
# Create a B matrix instance
# composed by 10 subpopulations of
# clones
B <- create_instance(
       n = 10, 
       m = 4, 
       k = 1, 
       selection = "neutral")$B


# Create a new 'Phylotree' object
# on the basis of the B matrix
phylotree1 <- B_to_phylotree(B = B)


# Create a new 'Phylotree' object
# with the general constructor of
# the class
phylotree2 <- create_phylotree(
                B = B, 
                clones = phylotree1@clones, 
                genes = phylotree1@genes, 
                parents = phylotree1@parents, 
                tree = phylotree1@tree)


# Generate the tags for the genes of
# the phyogenetic tree
tags <- LETTERS[1:nrow(B)]

 
# Create a new 'Phylotree' object
# with the general constructor of
# the class using tags
phylotree_tags <- create_phylotree(
                    B = B, 
                    clones = phylotree1@clones, 
                    genes = phylotree1@genes, 
                    parents = phylotree1@parents, 
                    tree = phylotree1@tree, 
                    labels = tags)
}
