% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_control_dataset.R
\name{create_control_dataset}
\alias{create_control_dataset}
\title{Create dataset with control}
\usage{
create_control_dataset(
  dat,
  control_protein = dat[["Protein"]][1],
  control_state = dat[["State"]][1],
  control_exposure = max(dat[["Exposure"]])
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{control_protein}{maximal exchange control protein, from dat.}

\item{control_state}{maximal exchange control state, from dat.}

\item{control_exposure}{maximal exchange control exposure (time
point of measurement), from dat.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
This function adds selected experimental maximal 
exchange control as a measurement for all biological states.
}
\details{
Function \code{\link{create_control_dataset}}
creates a dataset (similar to the output of \code{\link{read_hdx}} 
function), with maximal exchange control for all the states,
based on provided parameters. The other functions are operating 
within a state, so the control is prepared for each state. 
The chosen maximal exchange control is distinguishable by the value 
`99999` in `Exposure` control.
}
\examples{
head(create_control_dataset(alpha_dat))

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_state_uptake}}
}
