% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_uptake_dataset.R
\name{create_uptake_dataset}
\alias{create_uptake_dataset}
\title{Create uptake dataset for multiple states}
\usage{
create_uptake_dataset(
  dat,
  protein = unique(dat[["Protein"]])[1],
  states = unique(dat[["State"]]),
  time_0 = min(dat[["Exposure"]]),
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{states}{list of biological states for chosen protein.}

\item{time_0}{minimal exchange control time point of measurement [min].}

\item{time_100}{maximal exchange control time point of measurement [min].}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculates deuterium uptake values for selected 
biological states in multiple time points of measurements.
}
\details{
Function \code{\link{create_uptake_dataset}} generates 
a dataset with deuterium uptake values in different forms. For each
peptide in chosen protein in chosen states for time points of measurement
between minimal and maximal control time points of measurement deuterium 
uptake, fractional deuterium uptake with respect to controls or theoretical
tabular values are calculated, with combined and propagated uncertainty. 
Each peptide has an ID, based on its start position. 
This function is a wrapper for \code{\link{create_state_uptake_dataset}}
but for multiple states. 
The output of this function can be presented in a form of 
comparison plot.
}
\examples{
uptake_dat <- create_uptake_dataset(alpha_dat, states = c("Alpha_KSCN", "ALPHA_Gamma"))
head(uptake_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_state_uptake}}
\code{\link{create_state_uptake_dataset}}
}
