% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Difference.R
\name{Difference}
\alias{Difference}
\alias{twosample.difference}
\title{Two-Sample Test Based on Mean or Median}
\description{
Performs mean/median based two-sample test on samples.
}
\examples{
pmt(
    "twosample.difference", method = "mean",
    alternative = "greater", n_permu = 0
)$test(Table2.1.1)$print()$plot(
    style = "graphic", breaks = seq(-20, 25, length.out = 9)
)

pmt(
    "twosample.difference", method = "mean",
    alternative = "greater", n_permu = 1000
)$test(Table2.3.1)$print()

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:TwoSampleTest]{LearnNonparam::TwoSampleTest}} -> \code{\link[LearnNonparam:TwoSampleLocationTest]{LearnNonparam::TwoSampleLocationTest}} -> \code{Difference}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Difference-new}{\code{Difference$new()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="plot"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-plot'><code>LearnNonparam::PermuTest$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Difference-new"></a>}}
\if{latex}{\out{\hypertarget{method-Difference-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Difference} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Difference$new(
  method = c("mean", "median"),
  alternative = c("two_sided", "less", "greater"),
  null_value = 0,
  n_permu = 10000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{a character string specifying whether to use the mean or the median.}

\item{\code{alternative}}{a character string specifying the alternative hypothesis.}

\item{\code{null_value}}{a number indicating the true value of the location shift.}

\item{\code{n_permu}}{an integer indicating number of permutations for the permutation distribution. If set to \code{0}, all permutations will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Difference} object.
}
}
}
