% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{createLipidDB}
\alias{createLipidDB}
\title{Customizable lipid DBs creator}
\usage{
createLipidDB(lipid, chains, chains2)
}
\arguments{
\item{lipid}{character value indicating the class of lipid. See Details.}

\item{chains}{character vector indicating the FA chains to be employed}

\item{chains2}{character vector containing the sphingoid bases to be employed
if required.}
}
\value{
List with the requested dbs (data frames)
}
\description{
It allows to create easy-customizable lipid DBs for annotation with LipidMS
package.
}
\details{
\code{lipidClass} argument needs to be one of the following
character values: "Cer", "CerP", "GlcCer", "SM", "Carnitine", "CE", "FA",
"HFA", "Sph" (sphingoid bases), "SphP", "MG", "LPA", , "LPC",
"LPE", "LPG", "LPI", "LPS", "FAHFA", "DG", "PC", "PE", "PG", "PI", "PS",
"PA", "TG", "CL", "PCo", "PCp", "PEo", "PEp", "LPCo", "LPCp", "LPEo", "LPEp" 
or "all".
}
\examples{
fas <- c("8:0", "10:0", "12:0", "14:0", "14:1", "15:0", "16:0", "16:1",
"17:0", "18:0", "18:1", "18:2", "18:3", "18:4", "20:0", "20:1", "20:2",
"20:3", "20:4", "20:5", "22:0", "22:1", "22:2", "22:3", "22:4", "22:5",
"22:6", "24:0", "24:1", "26:0")
sph <- c("16:0", "16:1", "18:0", "18:1")
sn1alkyllipids <- c("16:0", "18:0", "18:1")
sn1vinyllipids <- c("16:0", "18:0")
newdb <- createLipidDB(lipid = "PC", chains = fas, chains2 = sph)

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
