% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_ind_t.R
\name{d_ind_t}
\alias{d_ind_t}
\title{Cohen's d for Independent Samples Using the Pooled SD}
\usage{
d_ind_t(m1, m2, sd1, sd2, n1, n2, a = 0.05)
}
\arguments{
\item{m1}{Mean of group one.}

\item{m2}{Mean of group two.}

\item{sd1}{Standard deviation of group one.}

\item{sd2}{Standard deviation of group two.}

\item{n1}{Sample size of group one.}

\item{n2}{Sample size of group two.}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d_s}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)} confidence interval
for \eqn{d_s}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)} confidence interval
for \eqn{d_s}.}
  \item{M1, M2}{Group means.}
  \item{sd1, sd2}{Standard deviations for each group.}
  \item{se1, se2}{Standard errors for each group mean.}
  \item{M1low, M1high, M2low, M2high}{Confidence interval bounds
for each group mean.}
  \item{spooled}{Pooled standard deviation.}
  \item{sepooled}{Pooled standard error.}
  \item{n1, n2}{Group sample sizes.}
  \item{df}{Degrees of freedom (\eqn{n_1 - 1 + n_2 - 1}).}
  \item{t}{t-statistic.}
  \item{p}{p-value.}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d_s} and its CI.}
  \item{statistic}{APA-style formatted string for reporting
the t-statistic and p-value.}
}
}
\description{
Compute Cohen's \eqn{d_s} for between-subjects designs and a noncentral-t
confidence interval using the **pooled standard deviation**
as the denominator.
}
\details{
The pooled standard deviation is:
\deqn{s_{pooled} = \sqrt{ \frac{ (n_1 - 1)s_1^2 + (n_2 - 1)s_2^2 }
{n_1 + n_2 - 2} }}

Cohen's \eqn{d_s} is then:
\deqn{d_s = \frac{m_1 - m_2}{s_{pooled}}}

The corresponding t-statistic is:
\deqn{t = \frac{m_1 - m_2}{ \sqrt{ s_{pooled}^2/n_1 + s_{pooled}^2/n_2 }}}

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/indtm.html}{Learn more on our example page.}
}
\examples{
# The following example is derived from the "indt_data" dataset
# included in MOTE.

# A forensic psychologist examined whether being hypnotized during recall
# affects how well a witness remembers facts about an event.

t.test(correctq ~ group, data = indt_data)

# Direct entry of summary statistics:
d_ind_t(m1 = 17.75, m2 = 23, sd1 = 3.30,
        sd2 = 2.16, n1 = 4, n2 = 4, a = .05)

# Equivalent shorthand:
d_ind_t(17.75, 23, 3.30, 2.16, 4, 4, .05)

# Using raw data from the dataset:
d_ind_t(mean(indt_data$correctq[indt_data$group == 1]),
        mean(indt_data$correctq[indt_data$group == 2]),
        sd(indt_data$correctq[indt_data$group == 1]),
        sd(indt_data$correctq[indt_data$group == 2]),
        length(indt_data$correctq[indt_data$group == 1]),
        length(indt_data$correctq[indt_data$group == 2]),
        .05)
}
\keyword{between-subjects}
\keyword{deviation}
\keyword{effect}
\keyword{independent}
\keyword{pooled}
\keyword{size}
\keyword{standard}
\keyword{t-test}
