\name{Update_G_Omega}
\alias{Update_G_Omega}
\title{
Updates Row Cluster Membership Probabilities 
}
\description{
Updates the Row Cluster Membership Probabilities based on the current assignments of  rows to row clusters in E_ReMI clustering algorithm. 
}
\usage{
Update_G_Omega(DC, I, J, Updated_C, Updated_R)
}
\arguments{
  \item{DC}{
A numeric data matrix of size \code{I x J}, typically doubly centered, representing the two-mode data to be analyzed.
  }
  \item{I}{
  An integer specifying the number of row objects in the data matrix.
  }
  \item{J}{
  An integer specifying the number of column variables in the data matrix.
  }
  \item{Updated_C}{
  A binary matrix indicating the current cluster membership of columns.
  Each row corresponds to a column in \code{DC}, and each column represents a column cluster.
  }
  \item{Updated_R}{
  A binary matrix indicating the current cluster membership of rows.
  Each row corresponds to a row in \code{DC}, and each column represents a row cluster.
  }
}
\details{
This function is typically called within each iteration of a E-ReMI clustering algorithm, where the goal is to maximize 
the log-likelihood or minimize least squared of DC via row and column cluster memberships. Thus it updates model parameters
(row cluster membership probabilities) under E-ReMI clustering framework. 
}
\value{
A list with the following components:
  \item{Omega}{A numeric vector of updated row cluster membership probabilities.}
  \item{G}{The updated row by column clusters intercation matrix.}
  \item{M}{The reconstructed data matrix from the current estimates.}
  \item{Sigma}{The updated estimate of residual variance.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl),
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function assumes binary (one-hot encoded) cluster membership matrices \code{Updated_C} and \code{Updated_R}.
}
\seealso{
\code{\link{E_ReMI}}, \code{\link{REMAXINT}}, \code{\link[pracma]{pinv}}
}
\examples{
I <- 10; P <- 4; J <- 5; Q <- 2
DC <- matrix(rnorm(I*J), I, J)
Updated_R <- diag(1, I, P)
Updated_C <- diag(1, J, Q)
result <- Update_G_Omega(DC, I, J, Updated_C, Updated_R)
result
}
\keyword{row cluster membership matrix}
