% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients.R
\name{normalized_grad_alpha}
\alias{normalized_grad_alpha}
\title{Normalized gradient for alpha parameter
Computes the normalized gradient of the log-likelihood with respect to the alpha parameter
over a set of observations. This is useful for optimization routines where scale-invariant
updates are preferred.}
\usage{
normalized_grad_alpha(alpha, beta, delta, omega, x)
}
\arguments{
\item{alpha}{Stability parameter.}

\item{beta}{Skewness parameter.}

\item{delta}{Scale parameter.}

\item{omega}{Location parameter.}

\item{x}{Numeric vector of observations.}
}
\value{
Scalar value representing the normalized gradient.
}
\description{
Normalized gradient for alpha parameter
Computes the normalized gradient of the log-likelihood with respect to the alpha parameter
over a set of observations. This is useful for optimization routines where scale-invariant
updates are preferred.
}
