% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNM_control.R
\name{MNM_control}
\alias{MNM_control}
\title{Generate Nimble Code for Multi-Species N-Mixture (MNM) Models}
\usage{
MNM_control(
  model = "MNM",
  prior_detection_probability = "dnorm(0, 0.001)",
  prior_precision = "dwish(Omega[1:S,1:S], df)",
  prior_mean = "dnorm(0,0.001)",
  prior_mean_AR = "dnorm(0,0.001)",
  prior_sd_AR = "dexp(1)",
  prior_hurdle = "dbeta(1,1)",
  Xp = NULL,
  Xn = NULL
)
}
\arguments{
\item{model}{Character. Specifies the type of MNM model to generate. Options are:
\itemize{
\item \code{"MNM"}: Standard MNM model (default)
\item \code{"Hurdle"}: Hurdle MNM model
\item \code{"AR"}: Autoregressive MNM model
\item \code{"HurdleAR"}: Hurdle MNM model with autoregression
}}

\item{prior_detection_probability}{Character. Prior distribution for the detection probability intercept (\code{gamma}). Default is \code{'dnorm(0, 0.001)'}.}

\item{prior_precision}{Character. Prior distribution for the precision matrix for the species-level random effect. Default is \code{'dwish(Omega[1:S,1:S], df)'}.}

\item{prior_mean}{Character. Prior distribution for the mean of the species-level random effect (\code{mu}). Default is \code{'dnorm(0,0.001)'}.}

\item{prior_mean_AR}{Character. Prior distribution for the mean of the autoregressive random effect (\code{phi}). Default is \code{'dnorm(0,0.001)'}.}

\item{prior_sd_AR}{Character. Prior distribution for the standard deviation of the autoregressive random effect (\code{phi}). Default is \code{'dexp(1)'}.}

\item{prior_hurdle}{Character. Prior distribution for \code{theta}, the probability of structural zero in hurdle models. Default is \code{'dbeta(1,1)'}.}

\item{Xp}{Array. Covariates influencing detection probability. Dimensions depend on the model:
\itemize{
\item \eqn{R \times S \times P} for models without AR
\item \eqn{R \times S \times K \times P} for AR models
where:
\item \eqn{R}: Number of sites
\item \eqn{S}: Number of species
\item \eqn{K}: Number of time points
\item \eqn{P}: Number of covariates
}}

\item{Xn}{Array. Covariates influencing abundance. Dimensions depend on the model:
\itemize{
\item \eqn{R \times S \times P} for models without AR
\item \eqn{R \times S \times K \times P} for AR models
}}
}
\value{
Character. Nimble code for the specified MNM model, which can be used for further analysis or fitting.
}
\description{
This function generates Nimble code for fitting various Multi-Species N-Mixture (MNM) models. These models can include standard MNM, hurdle components, autoregressive (AR) components, or both hurdle and AR components.
}
\details{
The generated Nimble code can be used to fit Bayesian hierarchical MNM models. Users can specify prior distributions for key model parameters and provide covariate arrays that influence detection probability and abundance. The function validates prior specifications and adapts model code based on the selected model type. Supported models include:
\itemize{
\item \strong{MNM}: Standard MNM model
\item \strong{Hurdle}: MNM model with a hurdle component
\item \strong{AR}: MNM model with an autoregressive component
\item \strong{HurdleAR}: MNM model with both hurdle and AR components
}

This is an internal function, needed for implementing MNM models using the MNM_fit function. While the MNM_fit function allows the user to define prior distributions and linear covariates on detection probability and abundance, if the user wishes to implement more complex models in Nimble (via unsupported prior distributions or non-linear covariate effects), the Nimble model code may be extracted as in examples below, and modified by the user.
}
\examples{
# Example
# In order to implement scenarios involving nonlinear covariate effects or complex
#  interaction terms, the user is invited to extract and modify the MNM Nimble code:
model<-MNM_control(model="MNM")
cat(model)

}
