% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{EVSKUniS}
\alias{EVSKUniS}
\title{EVSK of the Uniform distribution on the sphere or its modulus}
\usage{
EVSKUniS(d, nCum = TRUE, Type = c("Standard", "Modulus"))
}
\arguments{
\item{d}{dimensions}

\item{nCum}{if it is FALSE then moments (up to the 4th order) are calculated.}

\item{Type}{specify the type of distribution: "Standard" for the Uniform distribution on the sphere,
or "Modulus" for the modulus of the Uniform distribution on the sphere.}
}
\value{
A list of computed moments and cumulants.

When Type is "Standard":
\item{EU1}{Mean vector}
\item{varU}{Covariance matrix}
\item{Skew.U}{Skewness vector (always zero)}
\item{Skew.tot}{Total skewness (always zero)}
\item{Kurt.U}{Kurtosis vector}
\item{Kurt.tot}{Total kurtosis}

When Type is "Modulus":
\item{EU1}{Mean vector}
\item{varU}{Covariance matrix}
\item{EU.k}{List of moments up to 4th order}
\item{cumU.k}{List of cumulants up to 4th order}
\item{skew.U}{Skewness vector}
\item{kurt.U}{Kurtosis vector}
}
\description{
Cumulants (up to the 4th order), skewness, and (excess) kurtosis of the d-variate Uniform distribution on
the sphere or the modulus of the d-variate Uniform distribution on the sphere.
}
\examples{
# Example for Standard type
EVSKUniS(d=3, Type="Standard")

# Example for Modulus type
EVSKUniS(d=3, Type="Modulus")
}
\references{
Gy. Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021 Proposition 5.3, p.297.

S. R. Jammalamadaka, E. Taufer, Gy. Terdik. On multivariate
skewness and kurtosis. Sankhya A, 83(2), 607-644.
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKGenHyp}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
