% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NUEsoil.R
\name{NUEsoil}
\alias{NUEsoil}
\title{Calculate NUE Soil}
\usage{
NUEsoil(PlantBM, SoilN, FertN)
}
\arguments{
\item{PlantBM}{A numeric vector of plant biomass.}

\item{SoilN}{A numeric value or vector for soil N content.}

\item{FertN}{A numeric value or vector for fertilizer N input.}
}
\value{
A numeric vector of NUEsoil values.
}
\description{
The biomass production per unit of available N.
Formula: NUEsoil = PlantBM / (FertN + SoilN)
}
\examples{
PlantBM <- c(100, 120, 130)
SoilN <- c(20, 20, 20)
FertN <- 50
NUEsoil(PlantBM, SoilN, FertN)
}
