% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Big_data.R
\name{GenModelMissGLMdata}
\alias{GenModelMissGLMdata}
\title{Generate data for Generalised Linear Models under model misspecification scenario}
\usage{
GenModelMissGLMdata(N,X_Data,Misspecification,Beta,Var_Epsilon,family)
}
\arguments{
\item{N}{the big data size}

\item{X_Data}{a matrix for the covariate data}

\item{Misspecification}{a vector of values for the misspecification}

\item{Beta}{a vector for the model parameters, including the intercept and misspecification term}

\item{Var_Epsilon}{variance value for the residuals}

\item{family}{a character vector for "linear", "logistic" and "poisson" regression from Generalised Linear Models}
}
\value{
The output of \code{GenModelMissGLMdata} gives a list of

\code{Complete_Data} a matrix for Y,X and f(x)
}
\description{
Function to simulate big data under Generalised Linear Models for the model misspecification scenario through
any misspecification type.
}
\details{
Big data for the Generalised Linear Models are generated by the "linear", "logistic" and "poisson"
regression types under model misspecification.
}
\examples{
Beta<-c(-1,0.75,0.75,1); Var_Epsilon<-0.5; family <- "linear"; N<-10000
X_1 <- replicate(2,stats::runif(n=N,min = -1,max = 1))

Temp<-Rfast::rowprods(X_1)
Misspecification <- (Temp-mean(Temp))/sqrt(mean(Temp^2)-mean(Temp)^2)
X_Data <- cbind(X0=1,X_1);

Results<-GenModelMissGLMdata(N,X_Data,Misspecification,Beta,Var_Epsilon,family)

Results<-GenModelMissGLMdata(N,X_Data,Misspecification,Beta,Var_Epsilon=NULL,family="logistic")

Results<-GenModelMissGLMdata(N,X_Data,Misspecification,Beta,Var_Epsilon=NULL,family="poisson")

}
\references{
\insertRef{adewale2009robust}{NeEDS4BigData}

\insertRef{adewale2010robust}{NeEDS4BigData}
}
