% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.ConfusionTable}
\alias{print.ConfusionTable}
\title{Prints all details about a ConfusionTable object.}
\usage{
\method{print}{ConfusionTable}(x, ...)
}
\arguments{
\item{x}{A ConfusionTable object as it is returned by \code{\link{confusionTable}}-function.}

\item{...}{Further parameters}
}
\description{
Prints all details about a ConfusionTable object.
}
\details{
Prints all conditional prediction rates for the specified cascade.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

# Calculation of the confusion matrix for '0>2>3>4'.
confTable = confusionTable(predMap, cascade = '0>2>3>4')

print(confTable)
}
