% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OVL_derivates_2.R
\name{OVL_derivates_2}
\alias{OVL_derivates_2}
\title{Numerical derivatives of the overlap functional (2-component mixture vs. 2-component mixture).}
\usage{
OVL_derivates_2(
  mu1_hat,
  mu2_hat,
  sigma1_hat,
  sigma2_hat,
  pi1_hat,
  pi2_hat,
  h,
  intersec,
  OVL_mix
)
}
\arguments{
\item{mu1_hat}{Numeric vector of length 2. Estimated means for the first mixture.}

\item{mu2_hat}{Numeric vector of length 2. Estimated means for the second mixture.}

\item{sigma1_hat}{Numeric vector of length 2. Estimated standard deviations for the first mixture.}

\item{sigma2_hat}{Numeric vector of length 2. Estimated standard deviations for the second mixture.}

\item{pi1_hat}{Either a numeric scalar in [0,1] giving the mixing proportion of the first component in the first
mixture, or a numeric vector of length 2 with elements summing to 1.}

\item{pi2_hat}{Either a numeric scalar in [0,1] giving the mixing proportion of the first component in the second
mixture, or a numeric vector of length 2 with elements summing to 1.}

\item{h}{Positive numeric scalar. Base step size for finite differences.}

\item{intersec}{Numeric vector. Intersection points used as cutpoints.}

\item{OVL_mix}{Function that evaluates the overlap-related expression at cutpoints.}
}
\value{
A list with components \code{deriv1}–\code{deriv10}.
}
\description{
Computes finite-difference approximations of the partial derivatives of the
overlap coefficient with respect to the parameters when both groups are
modeled as two-component Gaussian mixtures.
}
\details{
This function is intended for internal use (delta-method variance estimation).
}
\keyword{internal}
