% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_smoothed_hazard}
\alias{f_plot_smoothed_hazard}
\title{Smoothed Hazard Function Plot}
\usage{
f_plot_smoothed_hazard(PERSUADE)
}
\arguments{
\item{PERSUADE}{A PERSUADE object created by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}
}
\value{
A base R plot of smoothed hazards by group.
}
\description{
Plots smoothed hazard estimates for each group in the PERSUADE object.
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_smoothed_hazard(PERSUADE)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
